/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class TessellatorFont {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean drawing = false;
    private int color;
    private final int vao;
    private final int vbo;
    @NotNull
    private final String name;
    private ByteBuffer data;
    private int vertexCount;

    public TessellatorFont(@NotNull String name, int initialCapacity) {
        this.name = name;
        this.data = BufferUtils.createByteBuffer(initialCapacity);
        this.vao = GL41.glGenVertexArrays();
        this.vbo = GL41.glGenBuffers();
        GL41.glBindVertexArray(this.vao);
        GL41.glBindBuffer(34962, this.vbo);
        int vertSize = 40;
        int offset = 0;
        GL41.glVertexAttribPointer(0, 2, 5126, false, vertSize, offset);
        GL41.glVertexAttribPointer(1, 2, 5126, false, vertSize, offset += 8);
        GL41.glVertexAttribPointer(2, 1, 5126, false, vertSize, offset += 8);
        GL41.glVertexAttribPointer(3, 4, 5121, true, vertSize, offset += 4);
        GL41.glVertexAttribPointer(4, 2, 5126, false, vertSize, offset += 4);
        GL41.glVertexAttribPointer(5, 2, 5126, false, vertSize, offset += 8);
        offset += 8;
        GL41.glVertexAttrib2f(6, 0.96875f, 0.96875f);
        GL41.glEnableVertexAttribArray(0);
        GL41.glEnableVertexAttribArray(1);
        GL41.glEnableVertexAttribArray(2);
        GL41.glEnableVertexAttribArray(3);
        GL41.glEnableVertexAttribArray(4);
        GL41.glEnableVertexAttribArray(5);
        GL41.glBindVertexArray(0);
    }

    public void startDrawing() {
        if (this.drawing) {
            this.drawing = false;
            throw new IllegalStateException(this.name + " already drawing!");
        }
        this.drawing = true;
        this.vertexCount = 0;
        this.data.clear();
        this.setColor1i(-1);
    }

    public void addChar(double x, double y, double width, double height, double shift, double u, double v, double uSize, double vSize) {
        this.checkIsDrawing();
        this.checkCanFit(64);
        this.data.putFloat((float)x);
        this.data.putFloat((float)y);
        this.data.putFloat((float)width);
        this.data.putFloat((float)height);
        this.data.putFloat((float)shift);
        this.data.putInt(this.color);
        this.data.putFloat((float)u);
        this.data.putFloat((float)v);
        this.data.putFloat((float)uSize);
        this.data.putFloat((float)vSize);
        ++this.vertexCount;
    }

    public void draw() {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
        this.drawing = false;
        if (this.vertexCount == 0) {
            return;
        }
        GL41.glBindVertexArray(this.vao);
        GL41.glBindBuffer(34962, this.vbo);
        GL41.glVertexAttrib2f(6, GLRenderer.getLightmapBlock(), GLRenderer.getLightmapSky());
        GL41.glBufferData(34962, this.data.flip(), 35040);
        GL41.glDrawArrays(DrawMode.POINTS.cap, 0, this.vertexCount);
        GL41.glBindVertexArray(0);
    }

    public void setColor1i(int argb) {
        this.checkIsDrawing();
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    public void setColor2i(int rgb, int a) {
        this.setColor1i(rgb & 0xFFFFFF | a << 24 & 0xFF000000);
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
    }

    public void checkCanFit(int size) {
        if (this.data.capacity() < this.data.position() + size) {
            int newSize = this.data.capacity() * 2;
            LOGGER.info("Expanding {} Buffer ({} -> {})", this.name, this.data.capacity(), newSize);
            ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
            this.data.flip();
            newBuffer.put(this.data);
            this.data = newBuffer;
        }
    }
}

