/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorBase;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public class TessellatorShader
extends TessellatorBase
implements TessellatorGeneral {
    private boolean lockColor = false;
    private boolean quadEmulation = false;
    private boolean enableColor;
    private boolean enableTexture;
    private boolean enableLightmap;
    private boolean enableNormal;
    private int color;
    private int lightmap;
    private float texU;
    private float texV;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    public final int vao = GL41.glGenVertexArrays();
    public final int vbo = GL41.glGenBuffers();
    private int quadVertCount = 0;

    public TessellatorShader(@NotNull String name, int initialCapacity) {
        super(name, initialCapacity);
    }

    @Override
    public void startDrawing(@NotNull DrawMode drawMode) {
        super.startDrawing(drawMode);
        this.lockColor = false;
        this.enableColor = false;
        this.enableTexture = false;
        this.enableLightmap = false;
        this.enableNormal = false;
        boolean bl = this.quadEmulation = drawMode == DrawMode.QUADS;
        if (this.quadEmulation) {
            this.drawMode = DrawMode.TRIANGLES;
        }
        this.quadVertCount = 0;
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        this.checkCanFit(64);
        this.data.putFloat((float)(this.offsetX + x));
        this.data.putFloat((float)(this.offsetY + y));
        this.data.putFloat((float)(this.offsetZ + z));
        if (this.enableColor) {
            this.data.putInt(this.color);
        }
        if (this.enableTexture) {
            this.data.putFloat(this.texU);
            this.data.putFloat(this.texV);
        }
        if (this.enableLightmap) {
            this.data.put((byte)((LightmapHelper.getBlockLightFromCoord(this.lightmap) << 4) + 7));
            this.data.put((byte)((LightmapHelper.getSkyLightFromCoord(this.lightmap) << 4) + 7));
        }
        if (this.enableNormal) {
            this.data.put(this.normalX);
            this.data.put(this.normalY);
            this.data.put(this.normalZ);
        }
        ++this.vertexCount;
        if (this.quadEmulation && this.quadVertCount % 4 == 2) {
            int vertSize = this.getVertexSize();
            this.checkCanFit(128);
            this.data.put(this.data.position(), this.data, this.data.position() - vertSize * 3, vertSize);
            this.data.put(this.data.position() + vertSize, this.data, this.data.position() - vertSize, vertSize);
            this.data.position(this.data.position() + vertSize * 2);
            this.vertexCount += 2;
        }
        ++this.quadVertCount;
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockColor = true;
    }

    @Override
    public void setColor1i(int argb) {
        this.checkIsDrawing();
        if (this.lockColor) {
            return;
        }
        if (!this.enableColor) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " color is disabled!");
            }
            this.enableColor = true;
        }
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        if (!this.enableTexture) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " texture is disabled!");
            }
            this.enableTexture = true;
        }
        this.texU = (float)u;
        this.texV = (float)v;
    }

    @Override
    public void setLightmapCoord1i(int lightmapCoord) {
        this.checkIsDrawing();
        if (!this.enableLightmap) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " lightmap is disabled!");
            }
            this.enableLightmap = true;
        }
        this.lightmap = lightmapCoord;
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        if (!this.enableNormal) {
            if (this.vertexCount > 0) {
                this.drawing = false;
                throw new IllegalStateException(this.name + " normal is disabled!");
            }
            this.enableNormal = true;
        }
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    @Override
    public void draw() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.vertexCount == 0) {
            return;
        }
        this.enableVertexAttribs(this.vao, this.vbo);
        GL41.glBufferData(34962, this.data.flip(), 35040);
        GLRenderer.render(this.vao, this.vbo, 0, this.vertexCount, this.drawMode);
    }

    @Override
    @NotNull
    public RenderBuffer record(int vao, int vbo) {
        this.checkIsDrawing();
        this.drawing = false;
        this.enableVertexAttribs(vao, vbo);
        GL41.glBufferData(34962, this.data.flip(), 35044);
        GL41.glBindVertexArray(0);
        return new RenderBuffer(vao, vbo, 0, this.vertexCount, this.drawMode);
    }

    protected int getVertexSize() {
        int size = 12;
        if (this.enableColor) {
            size += 4;
        }
        if (this.enableTexture) {
            size += 8;
        }
        if (this.enableNormal) {
            size += 3;
        }
        if (this.enableLightmap) {
            size += 2;
        }
        return size;
    }

    protected void enableVertexAttribs(int vao, int vbo) {
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        int vertexSize = this.getVertexSize();
        int offset = 0;
        GL41.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
        offset += 12;
        GL41.glEnableVertexAttribArray(0);
        if (this.enableColor) {
            GL41.glVertexAttribPointer(1, 4, 5121, true, vertexSize, offset);
            offset += 4;
            GL41.glEnableVertexAttribArray(1);
        } else {
            GL41.glDisableVertexAttribArray(1);
            GL41.glVertexAttrib4f(1, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.enableTexture) {
            GL41.glVertexAttribPointer(2, 2, 5126, false, vertexSize, offset);
            offset += 8;
            GL41.glEnableVertexAttribArray(2);
        } else {
            GL41.glDisableVertexAttribArray(2);
        }
        if (this.enableLightmap) {
            GL41.glVertexAttribPointer(3, 2, 5121, true, vertexSize, offset);
            offset += 2;
            GL41.glEnableVertexAttribArray(3);
        } else {
            GL41.glDisableVertexAttribArray(3);
            GL41.glVertexAttrib2f(3, GLRenderer.getLightmapBlock(), GLRenderer.getLightmapSky());
        }
        if (this.enableNormal) {
            GL41.glVertexAttribPointer(4, 3, 5120, true, vertexSize, offset);
            offset += 3;
            GL41.glEnableVertexAttribArray(4);
        } else {
            GL41.glDisableVertexAttribArray(4);
            GL41.glVertexAttrib3f(4, 0.0f, -1.0f, 0.0f);
        }
    }
}

