/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlockSlab;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicSlab
extends BlockLogic {
    @NotNull
    public Block<?> modelBlock;
    public int modelBlockMetadata;
    public static final int MASK_STATE = 3;
    public static final int STATE_LOWER = 0;
    public static final int STATE_DOUBLE = 1;
    public static final int STATE_UPPER = 2;

    public BlockLogicSlab(@NotNull Block<?> block, @NotNull Block<?> modelBlock) {
        this(block, modelBlock, 0);
        block.setBlockItem(() -> new ItemBlockSlab(block));
    }

    public BlockLogicSlab(@NotNull Block<?> block, @NotNull Block<?> modelBlock, int modelBlockMetadata) {
        super(block, Materials.STONE);
        this.modelBlock = modelBlock;
        this.modelBlockMetadata = modelBlockMetadata;
        block.withLightBlock(1);
    }

    @Override
    public void initializeBlock() {
        this.block.withHardness(this.modelBlock.blockHardness);
        this.block.withBlastResistance(this.modelBlock.blastResistance / 3.0f);
        this.block.withLightEmission(this.modelBlock.emission);
    }

    @Override
    @NotNull
    public Material getMaterial() {
        return this.modelBlock.getMaterial();
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return switch (source.getBlockData(tilePos) & 3) {
            case 0 -> new AABBd(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            case 1 -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            default -> new AABBd(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        };
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int meta = source.getBlockData(tilePos);
        return (meta & 3) == 1;
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(@NotNull World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        return (meta & 3) != 0;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        int state = world.getBlockData(tilePos) & 3;
        return switch (side) {
            case Side.TOP -> {
                if (state == 2 || state == 1) {
                    yield FullSupport.INSTANCE;
                }
                yield PartialSupport.INSTANCE;
            }
            case Side.BOTTOM -> {
                if (state == 0 || state == 1) {
                    yield FullSupport.INSTANCE;
                }
                yield PartialSupport.INSTANCE;
            }
            default -> {
                switch (state) {
                    case 0: {
                        yield PartialSupport.INSTANCE.down();
                    }
                    case 2: {
                        yield PartialSupport.INSTANCE.up();
                    }
                }
                yield FullSupport.INSTANCE;
            }
        };
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] result;
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            ItemStack[] itemStackArray = new ItemStack[1];
            v1 = itemStackArray;
            itemStackArray[0] = new ItemStack(this.block);
        } else {
            v1 = result = null;
        }
        if (result != null) {
            for (ItemStack stack : result) {
                stack.setMetadata(data & 0xF0);
                stack.itemID = this.id();
                stack.stackSize = (data & 3) == 1 && dropCause != EnumDropCause.PICK_BLOCK ? 2 : 1;
            }
        }
        return result;
    }

    @Override
    public int tickDelay() {
        return this.modelBlock.tickDelay();
    }

    @Override
    public void onEntityInside(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity, @NotNull Vector3d velocityDirection) {
        this.modelBlock.onEntityInside(world, tilePos, entity, velocityDirection);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int data, boolean shouldCollideWithFluids) {
        return this.modelBlock.canCollideCheck(data, shouldCollideWithFluids);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        return world.getBlockId(tilePos.down(queryPos)) == this.id() || world.getBlockId(tilePos.up(queryPos)) == this.id() || super.canPlaceAt(world, tilePos);
    }

    @Override
    public void onEntityWalkedOn(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity walker) {
        this.modelBlock.onEntityWalkedOn(world, tilePos, walker);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.modelBlock.updateTick(world, tilePos, rand, false);
    }

    @Override
    public void onDestroyedByExplosion(@NotNull World world, @NotNull TilePosc tilePos) {
        this.modelBlock.onDestroyedByExplosion(world, tilePos);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        Direction dir = mob.getVerticalPlacementDirection(side, yHit);
        if (dir == Direction.DOWN) {
            world.setBlockDataNotify(tilePos, 0);
        }
        if (dir == Direction.UP) {
            world.setBlockDataNotify(tilePos, 2);
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        if (side == Side.TOP) {
            world.setBlockDataNotify(tilePos, 2);
        } else {
            world.setBlockDataNotify(tilePos, 0);
        }
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        this.onNeighborChanged(world, tilePos, 0);
        this.modelBlock.onPlacedByWorld(world, tilePos);
    }

    @Override
    public float getBlastResistance(@Nullable Entity entity) {
        return this.modelBlock.getBlastResistance(entity);
    }

    @Override
    public float getBrightness(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.modelBlock.getBrightness(source, tilePos);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        this.modelBlock.onAttacked(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return this.modelBlock.onInteracted(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        this.modelBlock.animationTick(world, tilePos, rand);
    }

    @Override
    @NotNull
    public MaterialColor getMaterialColor() {
        return this.modelBlock.getMaterialColor();
    }
}

