/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicTrapDoor;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicTrapDoorPainted
extends BlockLogicTrapDoor
implements IPainted {
    public BlockLogicTrapDoorPainted(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return itemStack.getMetadata() | super.getPlacedData(player, itemStack, world, tilePos, side, xHit, yHit);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.TRAPDOOR_PLANKS_PAINTED, 1, (data >> 4 & 0xF) << 4)};
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta >> 4 & 0xF);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta << 4;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    @Override
    public void removeDye(World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataNotify(tilePos, Blocks.TRAPDOOR_PLANKS_OAK.id(), meta & 0xF);
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        IPainted.super.setColor(world, tilePos, color);
    }
}

