/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class WorleyNoise {
    @NotNull
    private static final Vector2fc HASH_CONST_2D_A = new Vector2f(127.1f, 311.7f);
    @NotNull
    private static final Vector2fc HASH_CONST_2D_B = new Vector2f(269.5f, 183.3f);
    @NotNull
    private static final Vector3fc HASH_CONST_3D_A = new Vector3f(127.1f, 311.7f, 74.7f);
    @NotNull
    private static final Vector3fc HASH_CONST_3D_B = new Vector3f(269.5f, 183.3f, 246.1f);
    @NotNull
    private static final Vector3fc HASH_CONST_3D_C = new Vector3f(113.5f, 271.9f, 124.6f);
    private static final float HASH_CONST_MULT = 18.5453f;

    private WorleyNoise() {
    }

    public static void getWorleyDistance2d(@NotNull Vector2fc xy, @NotNull Result result) {
        int j;
        int i;
        @NotNull Vector2f ip = xy.floor(new Vector2f());
        @NotNull Vector2f fp = xy.sub(ip, new Vector2f());
        @NotNull Vector2f mg = new Vector2f();
        @NotNull Vector2f mr = new Vector2f();
        float md = 8.0f;
        int index = 0;
        @NotNull Vector2f g = new Vector2f();
        @NotNull Vector2f o = new Vector2f();
        @NotNull Vector2f r = new Vector2f();
        @NotNull Vector2f pos = new Vector2f();
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                g.set((float)i, j);
                WorleyNoise.hash(ip.add(g, pos), o);
                g.add(o, r).sub(fp);
                float d = r.dot(r);
                if (!(d < md)) continue;
                md = d;
                mr.set(r);
                mg.set(g);
                index = (int)(o.x * 10.0f) + (int)(o.y * 10.0f);
            }
        }
        md = 8.0f;
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                g.set(mg).add(i, j);
                ip.add(g, pos);
                WorleyNoise.hash(ip.add(g, pos), o);
                g.add(o, r).sub(fp);
                pos.set(mr).sub(r);
                if (!(pos.dot(pos) > 1.0E-5f)) continue;
                g.set(mr).add(r).mul(0.5f);
                o.set(r).sub(mr).normalize();
                md = Math.min(md, g.dot(o));
            }
        }
        result.distance = 1.0f - md;
        result.index = index;
    }

    public static void getWorleyDistance3d(@NotNull Vector3fc xyz, @NotNull Result result) {
        int k;
        int j;
        int i;
        @NotNull Vector3f ip = xyz.floor(new Vector3f());
        @NotNull Vector3f fp = xyz.sub(ip, new Vector3f());
        @NotNull Vector3f mg = new Vector3f();
        @NotNull Vector3f mr = new Vector3f();
        float md = 8.0f;
        int index = 0;
        @NotNull Vector3f g = new Vector3f();
        @NotNull Vector3f o = new Vector3f();
        @NotNull Vector3f r = new Vector3f();
        @NotNull Vector3f pos = new Vector3f();
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                for (k = -1; k <= 1; ++k) {
                    g.set(i, j, k);
                    WorleyNoise.hash(ip.add(g, pos), o);
                    g.add(o, r).sub(fp);
                    float d = r.dot(r);
                    if (!(d < md)) continue;
                    md = d;
                    mr.set(r);
                    mg.set(g);
                    index = (int)(o.x * 10.0f) + (int)(o.y * 10.0f) + (int)(o.z * 10.0f);
                }
            }
        }
        md = 8.0f;
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                for (k = -2; k <= 2; ++k) {
                    g.set(mg).add(i, j, k);
                    ip.add(g, pos);
                    WorleyNoise.hash(ip.add(g, pos), o);
                    g.add(o, r).sub(fp);
                    pos.set(mr).sub(r);
                    if (!(pos.dot(pos) > 1.0E-5f)) continue;
                    g.set(mr).add(r).mul(0.5f);
                    o.set(r).sub(mr).normalize();
                    md = Math.min(md, g.dot(o));
                }
            }
        }
        result.distance = 1.0f - md;
        result.index = index;
    }

    private static void hash(@NotNull Vector2fc p, @NotNull Vector2f out) {
        out.x = p.dot(HASH_CONST_2D_A);
        out.y = p.dot(HASH_CONST_2D_B);
        WorleyNoise.sin(out, out);
        out.mul(18.5453f, out);
        WorleyNoise.fract(out, out);
    }

    private static void hash(@NotNull Vector3fc p, @NotNull Vector3f out) {
        out.x = p.dot(HASH_CONST_3D_A);
        out.y = p.dot(HASH_CONST_3D_B);
        out.z = p.dot(HASH_CONST_3D_C);
        WorleyNoise.sin(out, out);
        out.mul(18.5453f, out);
        WorleyNoise.fract(out, out);
    }

    private static void sin(@NotNull Vector2fc p, @NotNull Vector2f out) {
        out.x = (float)Math.sin(p.x());
        out.y = (float)Math.sin(p.y());
    }

    private static void sin(@NotNull Vector3fc p, @NotNull Vector3f out) {
        out.x = (float)Math.sin(p.x());
        out.y = (float)Math.sin(p.y());
        out.z = (float)Math.sin(p.z());
    }

    private static void fract(@NotNull Vector2fc p, @NotNull Vector2f out) {
        out.x = p.x() - (float)MathHelper.floor_float(p.x());
        out.y = p.y() - (float)MathHelper.floor_float(p.y());
    }

    private static void fract(@NotNull Vector3fc p, @NotNull Vector3f out) {
        out.x = p.x() - (float)MathHelper.floor_float(p.x());
        out.y = p.y() - (float)MathHelper.floor_float(p.y());
        out.z = p.z() - (float)MathHelper.floor_float(p.z());
    }

    public static class Result {
        public float distance;
        public int index;
    }
}

