#version 410 core

#define FOG
#define RADIAL_FOG

uniform int isEyeInLiquid;

uniform mat4 projectionInv;
uniform float viewWidth;
uniform float viewHeight;

in vec4 Color;
in vec2 TexCoord;

out vec4 FragColor;

uniform vec4 ufogColor;
uniform int ufogMode;
uniform float ufogStart;
uniform float ufogEnd;
uniform float ufogDensity;

uniform sampler2D texture0;
uniform sampler2D texture1;

void main() {
	vec4 tex = texture(texture0, TexCoord);
	
	// Alpha test
	if(tex.a < 0.1f) {
		discard;
	}
	
	// Hide clouds when in water or lava
	if(isEyeInLiquid != 0) {
		discard;
	}
	
	vec4 col = Color;

	float fogStrength = 0.0f;

	vec4 fragPos = projectionInv * vec4((gl_FragCoord.xy / vec2(viewWidth, viewHeight)) * 2.0f - 1.0f, gl_FragCoord.z * 2.0f - 1.0f, 1.0f);
	fragPos /= fragPos.w;
	
	float dist = length(fragPos.xyz);
	float end = (ufogEnd * 1.5f);
	float start = ufogStart / (ufogEnd * 1.5f);

	fogStrength = dist / end;
	fogStrength -= start;
	fogStrength /= (1.0f - start);
	fogStrength = clamp(fogStrength, 0.0f, 1.0f);
	col.a *= 1.0f - fogStrength;
	
	FragColor = tex * col;
}