#version 410 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec4 aColor;
layout (location = 2) in vec2 aUV;
//layout (location = 3) in vec2 aLightmap;
//layout (location = 4) in vec3 aNormal;

out vec4 Color;
out vec2 TexCoord;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main() {
	TexCoord = aUV;
	Color = aColor;

	gl_Position = projection * view * model * vec4(aPos, 1);
}