#version 410 core

out vec4 FragColor;

in vec4 Color;
in vec2 LightMapCoord;
in float Distance;
in vec3 Light;

uniform vec4 ucolor;

uniform vec4 ufogColor;
uniform int ufogMode;
uniform float ufogStart;
uniform float ufogEnd;
uniform float ufogDensity;

uniform sampler2D texture1;

// Taken from https://github.com/hughsk/glsl-fog
float fogFactorLinear() {
    return 1.0 - clamp(((ufogEnd - (Distance)) / (ufogEnd - ufogStart)), 0.0, 1.0);
}

float fogFactorExp() {
    return 1.0 - clamp(exp(-ufogDensity * (Distance)), 0.0, 1.0);
}

float fogFactorExp2() {
    float LOG2 = -1.442695;
    float d = ufogDensity * (Distance);
    return 1.0 - clamp(exp2(d * d * LOG2), 0.0, 1.0);
}


vec4 computeFog(vec4 color) {
    float f = 0;
    if (ufogMode == 0) { // Linear
        f = fogFactorLinear();
    }
    else if (ufogMode == 1) { // EXP
        f = fogFactorExp();
    }
    else if (ufogMode == 2) { // EXP2
        f = fogFactorExp2();
    }
    return vec4(mix(color.rgb, ufogColor.rgb, f), color.a);
}

void main() {
    vec4 lightColor = texture(texture1, LightMapCoord);

    vec4 oColor = lightColor * Color * ucolor;
    vec4 litColor = vec4(oColor.rgb * clamp(Light, 0, 1), oColor.a);

    FragColor = computeFog(oColor);
    if (FragColor.a < 0.1f) {
        discard;
    }
}
