/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.nbt.tags.CompoundTag;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenCreateWorld;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveFile;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ScreenSelectWorld
extends Screen {
    private final DateFormat dateFormatter = new SimpleDateFormat();
    protected String stringTitle = "Select world";
    private boolean selected = false;
    private int selectedWorld = -1;
    private List<SaveFile> saveList;
    private Map<SaveFile, @Nullable CompoundTag> userTags;
    private WorldSlot worldSlotContainer;
    private String stringWorld;
    private String stringConversion;
    private boolean deleting;
    private ButtonElement buttonRename;
    private ButtonElement buttonSelect;
    private ButtonElement buttonDelete;

    public ScreenSelectWorld(Screen parent) {
        super(parent);
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        this.stringTitle = i18n.translateKey("gui.select_world.label.title");
        this.stringWorld = i18n.translateKey("gui.select_world.label.world");
        this.stringConversion = i18n.translateKey("gui.select_world.label.must_be_converted");
        this.loadSaves();
        this.worldSlotContainer = new WorldSlot();
        this.initButtons();
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        super.keyPressed(eventCharacter, eventKey, mx, my);
        if (eventKey == Keyboard.KEY_UP && this.selectedWorld > 0) {
            this.worldSlotContainer.selectItem(this.selectedWorld - 1, false);
        }
        if (eventKey == Keyboard.KEY_DOWN && this.selectedWorld < this.saveList.size() - 1) {
            this.worldSlotContainer.selectItem(this.selectedWorld + 1, false);
        }
        if (eventKey == Keyboard.KEY_DELETE) {
            this.tryDeleteWorld(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT));
        }
    }

    private void loadSaves() {
        ISaveFormat saveFormat = this.mc.getSaveFormat();
        this.saveList = saveFormat.getSaveFileList();
        this.userTags = new HashMap<SaveFile, CompoundTag>();
        for (SaveFile file : this.saveList) {
            LevelStorage levelStorage = saveFormat.getSaveHandler(file.getFileName(), false);
            LevelData data = levelStorage.getLevelData();
            if (data != null && data.getLastPlayerUUID() != null) {
                this.userTags.put(file, levelStorage.getPlayerData(null, data.getLastPlayerUUID()));
                continue;
            }
            this.userTags.put(file, levelStorage.getPlayerData(this.mc.session.username, this.mc.session.uuid));
        }
        Collections.sort(this.saveList);
        if (this.selectedWorld >= this.saveList.size()) {
            this.selectedWorld = -1;
        }
    }

    protected String getSaveFileName(int i) {
        return this.saveList.get(i).getFileName();
    }

    protected String getSaveName(int i) {
        String s = this.saveList.get(i).getDisplayName();
        if (MathHelper.stringNullOrLengthZero(s)) {
            I18n i18n = I18n.getInstance();
            s = i18n.translateKeyAndFormat(this.stringWorld, i + 1);
        }
        return s;
    }

    public void initButtons() {
        I18n i18n = I18n.getInstance();
        this.buttonSelect = new ButtonElement(1, this.width / 2 - 154, this.height - 52, 150, 20, i18n.translateKey("gui.select_world.button.play_selected_world"));
        this.buttons.add(this.buttonSelect);
        this.buttonRename = new ButtonElement(6, this.width / 2 - 154, this.height - 28, 70, 20, i18n.translateKey("gui.select_world.button.rename"));
        this.buttons.add(this.buttonRename);
        this.buttonDelete = new ButtonElement(2, this.width / 2 - 74, this.height - 28, 70, 20, i18n.translateKey("gui.select_world.button.delete"));
        this.buttons.add(this.buttonDelete);
        this.buttons.add(new ButtonElement(3, this.width / 2 + 4, this.height - 52, 150, 20, i18n.translateKey("gui.select_world.button.create_new_world")));
        this.buttons.add(new ButtonElement(0, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.select_world.button.cancel")));
        this.buttonSelect.enabled = false;
        this.buttonRename.enabled = false;
        this.buttonDelete.enabled = false;
    }

    public void deletePresetWorld(String name) {
        for (int i = 0; i < this.saveList.size(); ++i) {
            SaveFile save = this.saveList.get(i);
            if (!save.getDisplayName().equals(name)) continue;
            this.deleting = true;
            this.deleteWorld(true, i);
            --i;
        }
    }

    void tryDeleteWorld(boolean skipConfirm) {
        if (this.selectedWorld < 0 || this.selectedWorld >= this.saveList.size()) {
            return;
        }
        String s = this.getSaveName(this.selectedWorld);
        if (s != null) {
            this.deleting = true;
            if (skipConfirm) {
                this.deleteWorld(true, this.selectedWorld);
            } else {
                I18n i18n = I18n.getInstance();
                PopupScreen popup = new PopupBuilder(this, 250).closeOnEsc(0).withLabel("gui.select_world.label.delete_title").withLabel("gui.select_world.label.delete_confirm.1").withLabelLiteral(i18n.translateKeyAndFormat("gui.select_world.label.delete_confirm.2", s)).withLabelLiteral("").withButtonGroup("endButtons", new String[]{"gui.select_world.button.delete", "gui.select_world.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                    if (statusCode == 1) {
                        this.deleteWorld(true, this.selectedWorld);
                    }
                }).build();
                this.mc.displayScreen(popup);
            }
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 2) {
            this.tryDeleteWorld(false);
        } else if (button.id == 1) {
            this.selectWorld(this.selectedWorld);
        } else if (button.id == 3) {
            this.mc.displayScreen(new ScreenCreateWorld(this));
        } else if (button.id == 6) {
            PopupScreen popup = new PopupBuilder(this, 140).closeOnEsc(0).closeOnEnter(1).withLabel("gui.select_world.label.rename_title").withLabel("gui.select_world.label.world_name").withTextField("nameField", this.getSaveName(this.selectedWorld)).withButtonGroup("endButtons", new String[]{"gui.select_world.button.rename", "gui.select_world.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    String text = (String)results.get("nameField");
                    ISaveFormat format = this.mc.getSaveFormat();
                    format.renameWorld(this.getSaveFileName(this.selectedWorld), text);
                    this.loadSaves();
                }
            }).build();
            this.mc.displayScreen(popup);
        } else if (button.id == 0) {
            this.mc.displayScreen(this.parentScreen);
        }
    }

    public void selectWorld(int i) {
        SaveFile save = this.saveList.get(i);
        if (save.isCorrupted()) {
            return;
        }
        if (save.getNeedsConversion()) {
            // empty if block
        }
        this.mc.displayScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.mc.playerController = new PlayerControllerSP(this.mc);
        Object s = this.getSaveFileName(i);
        if (s == null) {
            s = "World" + i;
        }
        this.mc.startWorld((String)s);
        this.mc.displayScreen(null);
    }

    public void deleteWorld(boolean flag, int i) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                ISaveFormat isaveformat = this.mc.getSaveFormat();
                isaveformat.flushCache();
                isaveformat.deleteSave(this.getSaveFileName(i));
                this.loadSaves();
                this.selectedWorld = -1;
            }
            this.mc.displayScreen(this);
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.worldSlotContainer.render(mx, my, partialTick);
        this.drawStringCenteredShadow(this.fontRenderer, this.stringTitle, this.width / 2, 20, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    class WorldSlot
    extends ScrolledSelectionList {
        @NotNull
        private final StringBuilder nameBuilder;
        @NotNull
        private final StringBuilder descBuilder1;
        @NotNull
        private final StringBuilder descBuilder2;

        public WorldSlot() {
            super(ScreenSelectWorld.this.mc, ScreenSelectWorld.this.width, ScreenSelectWorld.this.height, 32, ScreenSelectWorld.this.height - 64, 36);
            this.nameBuilder = new StringBuilder();
            this.descBuilder1 = new StringBuilder();
            this.descBuilder2 = new StringBuilder();
        }

        @Override
        protected int getItemCount() {
            return ScreenSelectWorld.this.saveList.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
            ScreenSelectWorld.this.selectedWorld = itemIndex;
            boolean flag1 = ScreenSelectWorld.this.selectedWorld >= 0 && ScreenSelectWorld.this.selectedWorld < this.getItemCount();
            boolean corrupted = ScreenSelectWorld.this.saveList.get(itemIndex) == null || ScreenSelectWorld.this.saveList.get(itemIndex).isCorrupted();
            ScreenSelectWorld.this.buttonSelect.enabled = flag1 && !corrupted;
            ScreenSelectWorld.this.buttonRename.enabled = flag1 && !corrupted;
            ScreenSelectWorld.this.buttonDelete.enabled = flag1;
            if (doubleClicked && flag1) {
                ScreenSelectWorld.this.selectWorld(itemIndex);
            }
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return itemIndex == ScreenSelectWorld.this.selectedWorld;
        }

        @Override
        protected int getMaxPosition() {
            return ScreenSelectWorld.this.saveList.size() * 36;
        }

        @Override
        protected void renderHoleBackground() {
            ScreenSelectWorld.this.renderBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, @NotNull TessellatorGeneral t) {
            this.nameBuilder.setLength(0);
            this.descBuilder1.setLength(0);
            this.descBuilder2.setLength(0);
            I18n i18n = I18n.getInstance();
            SaveFile saveFile = ScreenSelectWorld.this.saveList.get(index);
            CompoundTag userTag = ScreenSelectWorld.this.userTags.get(saveFile);
            Gamemode gamemode = userTag != null ? Gamemode.gamemodesList[userTag.getInteger("Gamemode")] : Gamemode.survival;
            String saveName = saveFile.getDisplayName();
            if (saveFile.isCorrupted()) {
                this.nameBuilder.append(TextFormatting.RED);
            }
            if (MathHelper.stringNullOrLengthZero(saveName)) {
                this.nameBuilder.append(i18n.translateKeyAndFormat(ScreenSelectWorld.this.stringWorld, index + 1));
            } else {
                this.nameBuilder.append(saveName);
            }
            long sizeBytes = saveFile.getSizeOnDisk();
            this.descBuilder1.append(saveFile.getFileName());
            this.descBuilder1.append(" (").append(ScreenSelectWorld.this.dateFormatter.format(new Date(saveFile.getLastTimePlayed())));
            this.descBuilder1.append(", ").append((float)(sizeBytes / 1024L * 100L / 1024L) / 100.0f).append(" MB)");
            if (saveFile.getNeedsConversion()) {
                this.descBuilder2.append(ScreenSelectWorld.this.stringConversion).append(" ");
            } else {
                I18n st = I18n.getInstance();
                LevelData ld = saveFile.getLevelData();
                DimensionData dd = (DimensionData)saveFile.getDimensionData().get(0);
                if (dd == null) {
                    this.descBuilder2.append(TextFormatting.RED).append(st.translateKey("gui.select_world.label.dimension_corrupted"));
                } else {
                    WorldType worldType;
                    this.descBuilder2.append(st.translateKey(gamemode.getLanguageKey() + ".name"));
                    if (ld != null && ld.getCheatsEnabled()) {
                        this.descBuilder2.append(" | ").append(st.translateKey("gui.select_world.label.cheats"));
                    }
                    if ((worldType = dd.getWorldType()) != null) {
                        this.descBuilder2.append(" | ").append(st.translateKey(dd.getWorldType().getLanguageKey() + ".name"));
                    } else {
                        this.descBuilder2.append(" | ").append(TextFormatting.RED).append(st.translateKey("gui.select_world.label.unknown"));
                    }
                }
            }
            ScreenSelectWorld.this.drawStringShadow(ScreenSelectWorld.this.fontRenderer, this.nameBuilder, x + 2, y + 1, 0xFFFFFF);
            ScreenSelectWorld.this.drawStringShadow(ScreenSelectWorld.this.fontRenderer, this.descBuilder1, x + 2, y + 12, 0x808080);
            ScreenSelectWorld.this.drawStringShadow(ScreenSelectWorld.this.fontRenderer, this.descBuilder2, x + 2, y + 12 + 10, 0x808080);
        }
    }
}

