/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.nbteditor.components;

import com.mojang.nbt.tags.ShortArrayTag;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.nbteditor.components.ArrayTagComponent;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;

public class ShortArrayTagComponent
extends ArrayTagComponent<short[]> {
    @NotNull
    public static final IconCoordinate icon = TextureRegistry.getTexture("minecraft:gui/screen/nbt/short_array_tag");

    public ShortArrayTagComponent(@NotNull Screen attachedScreen, @NotNull ShortArrayTag tag) {
        super(attachedScreen, tag);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(int mx, int my, float partialTick) {
        return icon;
    }

    @Override
    public void render(@NotNull TessellatorGeneral t, int offX, int offY, int mx, int my, float partialTick) {
        super.render(t, offX, offY, mx, my, partialTick);
        this.drawRect(offX + 12 + 1, offY, offX + this.width(mx, my, partialTick), offY + this.height(mx, my, partialTick), this.isHovered(mx, my, partialTick) ? -2006949728 : -2002739040);
        this.attachedScreen.fontRenderer.render(this.tag.getTagName(), offX + 12 + 1 + 2, offY + 2).setColor(DyeColor.YELLOW.color).call();
        this.attachedScreen.fontRenderer.render(": ", this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).setColor(DyeColor.YELLOW.color).call();
        this.attachedScreen.fontRenderer.render(((short[])this.tag.getValue()).length, this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).call();
        this.attachedScreen.fontRenderer.render(" shorts", this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).call();
    }

    @Override
    @NotNull
    public String valueToString() {
        StringBuilder builder = new StringBuilder();
        short[] shorts = (short[])this.tag.getValue();
        for (int i = 0; i < shorts.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(shorts[i]);
        }
        return builder.toString();
    }

    @Override
    public void parseValueFromString(@NotNull String valueString) throws Exception {
        String[] split = valueString.replace(" ", "").split(",");
        short[] shorts = new short[split.length];
        for (int i = 0; i < split.length; ++i) {
            shorts[i] = Short.parseShort(split[i]);
        }
        this.tag.setValue(shorts);
    }
}

