/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelAxisAligned<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelAxisAligned(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        Axis axis = BlockLogicAxisAligned.metaToAxis(meta);
        switch (axis) {
            case Y: {
                BlockModelAxisAligned.renderBlocks.uvRotateEast = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateWest = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateSouth = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateNorth = 0;
                break;
            }
            case Z: {
                BlockModelAxisAligned.renderBlocks.uvRotateSouth = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateNorth = 1;
                break;
            }
            case X: {
                BlockModelAxisAligned.renderBlocks.uvRotateEast = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateWest = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateTop = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateBottom = 1;
            }
        }
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos);
        renderBlocks.resetRenderBlocks();
        return true;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        Side rotated = this.getRotatedSide(side, data);
        if (rotated == Side.NONE) {
            return TextureRegistry.getTexture("minecraft:block/grass_top");
        }
        return super.getBlockTextureFromSideAndMetadata(rotated, data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(@NotNull Side side, int data) {
        Side rotated = this.getRotatedSide(side, data);
        if (rotated == Side.NONE) {
            return null;
        }
        return super.getBlockOverbrightTextureFromSideAndMeta(rotated, data);
    }

    public Side getRotatedSide(Side side, int data) {
        int d = 6 * (data & 3) + side.getId();
        return d < Sides.orientationLookUpXYZAligned.length ? Side.getSideById(Sides.orientationLookUpXYZAligned[d]) : Side.NONE;
    }
}

