/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelDoor<T extends BlockLogicDoor>
extends BlockModelStandard<T> {
    public BlockModelDoor(Block<T> block) {
        super(block);
    }

    public void setBrightness(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, float sideBrightness) {
        tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
        tessellator.setColorOpaque3f(sideBrightness, sideBrightness, sideBrightness);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        tessellator.setLightmapCoord1i(LightmapHelper.getLightmapCoord(15, 15));
        tessellator.setColorOpaque3f(1.0f, 1.0f, 1.0f);
        AABBdc bounds = this.block.getBoundsFromState(worldSource, tilePos);
        TilePos queryPos = new TilePos();
        float sideBottom = 1.0f;
        float sideTop = 1.0f;
        float sideNorthSouth = 1.0f;
        float sideEastWest = 1.0f;
        if (ENABLE_DIRECTIONAL_LIGHTING) {
            sideBottom = 0.5f;
            sideTop = 1.0f;
            sideNorthSouth = 0.8f;
            sideEastWest = 0.6f;
        }
        boolean aboveIsDoor = Block.hasLogicClass(worldSource.getBlock(tilePos.up(queryPos)), BlockLogicDoor.class);
        boolean belowIsDoor = Block.hasLogicClass(worldSource.getBlock(tilePos.down(queryPos)), BlockLogicDoor.class);
        int meta = worldSource.getBlockData(tilePos);
        if (!belowIsDoor) {
            this.setBrightness(tessellator, worldSource, tilePos.down(queryPos), sideBottom);
            renderBlocks.renderBottomFace(tessellator, bounds, tilePos, this.getBlockTexture(worldSource, tilePos, Side.BOTTOM));
        }
        if (!aboveIsDoor) {
            this.setBrightness(tessellator, worldSource, tilePos.up(queryPos), sideTop);
            renderBlocks.renderTopFace(tessellator, bounds, tilePos, this.getBlockTexture(worldSource, tilePos, Side.TOP));
        }
        if (bounds.minZ() > 0.0625) {
            this.setBrightness(tessellator, worldSource, tilePos, sideNorthSouth);
        } else {
            this.setBrightness(tessellator, worldSource, tilePos.north(queryPos), sideNorthSouth);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.NORTH, meta);
        IconCoordinate texture = this.getBlockTexture(worldSource, tilePos, Side.NORTH);
        renderBlocks.renderNorthFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        if (bounds.maxZ() < 0.9375) {
            this.setBrightness(tessellator, worldSource, tilePos, sideNorthSouth);
        } else {
            this.setBrightness(tessellator, worldSource, tilePos.south(queryPos), sideNorthSouth);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.SOUTH, meta);
        texture = this.getBlockTexture(worldSource, tilePos, Side.SOUTH);
        renderBlocks.renderSouthFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        if (bounds.minX() > 0.0625) {
            this.setBrightness(tessellator, worldSource, tilePos, sideEastWest);
        } else {
            this.setBrightness(tessellator, worldSource, tilePos.west(queryPos), sideEastWest);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.WEST, meta);
        texture = this.getBlockTexture(worldSource, tilePos, Side.WEST);
        renderBlocks.renderWestFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        if (bounds.maxX() < 0.9375) {
            this.setBrightness(tessellator, worldSource, tilePos, sideEastWest);
        } else {
            this.setBrightness(tessellator, worldSource, tilePos.east(queryPos), sideEastWest);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.EAST, meta);
        texture = this.getBlockTexture(worldSource, tilePos, Side.EAST);
        renderBlocks.renderEastFace(tessellator, bounds, tilePos, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    protected boolean shouldFlipTexture(@NotNull Side side, int meta) {
        if (side == Side.TOP || side == Side.BOTTOM) {
            return false;
        }
        int state = ((BlockLogicDoor)this.block.getLogic()).getRotation(meta);
        int l = state / 2 + (side.getId() & 1 ^ state);
        if ((state == 0 || state == 2) ^ side.getId() <= 3) {
            return false;
        }
        return ((l += (meta & 4) / 4) & 1) != 0;
    }
}

