/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLeavesCherryFlowering;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;

public class BlockModelLeavesCherryFlowering<T extends BlockLogic>
extends BlockModelLeaves<T> {
    private final IconCoordinate grownCherryOverlay = TextureRegistry.getTexture("minecraft:block/leaves/cherry_overlay");
    private final IconCoordinate floweringCherryOverlay = TextureRegistry.getTexture("minecraft:block/leaves/cherry_flowering_overlay");

    public BlockModelLeavesCherryFlowering(Block<T> block) {
        super(block, "minecraft:block/leaves/cherry");
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        super.render(tessellator, worldSource, tilePos);
        int growthRate = BlockLogicLeavesCherryFlowering.getGrowthRate(worldSource.getBlockData(tilePos));
        BlockModelLeavesCherryFlowering.renderBlocks.overrideBlockTexture = growthRate > 0 ? this.grownCherryOverlay : this.floweringCherryOverlay;
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsRaw(), tilePos, 1.0f, 1.0f, 1.0f);
        BlockModelLeavesCherryFlowering.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        super.renderStandalone(tessellator, metadata, lightmapCoord);
        AABBd bounds = this.block.getBoundsRaw();
        IconCoordinate cherryCoord = this.grownCherryOverlay;
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }
}

