/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.Arrays;
import net.minecraft.client.render.font.FontFile;
import net.minecraft.client.render.tessellator.TessellatorFont;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

public class FontMonospace
extends FontFile {
    public static final int MONOSPACE_WIDTH = 10;

    public FontMonospace(@NotNull String key) {
        super(key, "/assets/minecraft/textures/gui/font/monospace/mono_%02X.png", "");
    }

    @Override
    public void init(@NotNull TexturePackList packList) {
        Arrays.fill(this.texHandleCache, -1);
        Arrays.fill(this.charWidth, (byte)10);
    }

    @Override
    public boolean canRenderChar(char c) {
        return !DEFAULT_BLACKLIST.contains(Character.valueOf(c)) && ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) != -1 && (c == ' ' || this.textureForChar(c) != 0);
    }

    @Override
    public double charWidthDouble(char c) {
        return 6.0;
    }

    @Override
    public double renderChar(TessellatorFont tessellator, char c, double x, double y, double z, boolean italics) {
        if (c != ' ') {
            boolean shift = italics;
            int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
            if (fontIndex < 0) {
                return 0.0;
            }
            int upper = this.charWidth[fontIndex] >> 4;
            int lower = this.charWidth[fontIndex] & 0xF;
            int fUpper = upper;
            int fLower = lower + 1;
            int u = fontIndex % 16 * 16 + fUpper;
            int v = (fontIndex & 0xFF) / 16 * 16;
            int uWidth = fLower - fUpper;
            int vHeight = 16;
            double width = (double)uWidth / 2.0;
            double height = 8.0;
            tessellator.addChar(x, y, width, 8.0, (double)shift, (double)u / 256.0, (double)v / 256.0, (double)uWidth / 256.0, 0.0625);
        }
        return 6.0;
    }
}

