/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

interface BlockInterface {
    public int id();

    @NotNull
    public String getKey();

    @NotNull
    public NamespaceID namespaceId();

    public boolean isCubeShaped();

    @Deprecated
    public boolean canPlaceOnSurface();

    @Deprecated
    public boolean canPlaceOnSurfaceOnCondition(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public boolean canPlaceOnSurfaceOnCondition(@NotNull World world, int x, int y, int z) {
        return this.canPlaceOnSurfaceOnCondition(world, new TilePos(x, y, z));
    }

    public boolean renderAsNormalBlockOnCondition(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    default public boolean renderAsNormalBlockOnCondition(@NotNull WorldSource world, int x, int y, int z) {
        return this.renderAsNormalBlockOnCondition(world, new TilePos(x, y, z));
    }

    @Deprecated
    public boolean canPlaceOnSurface(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public boolean canPlaceOnSurfaceOfBlock(@NotNull World world, int x, int y, int z) {
        return this.canPlaceOnSurface(world, new TilePos(x, y, z));
    }

    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World var1, @NotNull EnumDropCause var2, @NotNull TilePosc var3, int var4, @Nullable TileEntity var5);

    @Deprecated
    default public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int x, int y, int z, int data, @Nullable TileEntity tileEntity) {
        return this.getBreakResult(world, dropCause, new TilePos(x, y, z), data, tileEntity);
    }

    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World var1, @NotNull EnumDropCause var2, int var3, @Nullable TileEntity var4);

    @NotNull
    public AABBdc getBounds();

    @NotNull
    public AABBd getBoundsRaw();

    public float getBrightness(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    default public float getBlockBrightness(@NotNull WorldSource source, int x, int y, int z) {
        return this.getBrightness(source, new TilePos(x, y, z));
    }

    public int getLightmapCoord(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    default public int getLightmapCoord(@NotNull WorldSource source, int x, int y, int z) {
        return this.getLightmapCoord(source, new TilePos(x, y, z));
    }

    public float getAmbientOcclusionStrength(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    default public float getAmbientOcclusionStrength(@NotNull WorldSource source, int x, int y, int z) {
        return this.getAmbientOcclusionStrength(source, new TilePos(x, y, z));
    }

    @NotNull
    public AABBdc getSelectionAABB(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    @NotNull
    default public AABBdc getSelectedBoundingBoxFromPool(@NotNull WorldSource world, int x, int y, int z) {
        return this.getSelectionAABB(world, new TilePos(x, y, z));
    }

    @Nullable
    public BoundingVolume getBoundingVolume(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    @Nullable
    default public BoundingVolume getBoundingVolume(@NotNull World world, int x, int y, int z) {
        return this.getBoundingVolume(world, new TilePos(x, y, z));
    }

    public void getCollisionAABBs(@NotNull World var1, @NotNull TilePosc var2, @NotNull AABBdc var3, @NotNull @NotNull List<@NotNull AABBdc> var4);

    @Deprecated
    default public void getCollidingBoundingBoxes(@NotNull World world, int x, int y, int z, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        this.getCollisionAABBs(world, new TilePos(x, y, z), aabb, aabbList);
    }

    public boolean collidesWithEntity(@NotNull Entity var1, @NotNull World var2, @NotNull TilePosc var3);

    @Deprecated
    default public boolean collidesWithEntity(@NotNull Entity entity, @NotNull World world, int x, int y, int z) {
        return this.collidesWithEntity(entity, world, new TilePos(x, y, z));
    }

    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    @Nullable
    default public AABBdc getCollisionBoundingBoxFromPool(@NotNull WorldSource source, int x, int y, int z) {
        return this.getCollisionAABB(source, new TilePos(x, y, z));
    }

    public boolean isSolidRender();

    public boolean blocksLight();

    public boolean canCollideCheck(int var1, boolean var2);

    public boolean isCollidable();

    public void updateTick(@NotNull World var1, @NotNull TilePosc var2, @NotNull Random var3, boolean var4);

    @Deprecated
    default public void updateTick(@NotNull World world, int x, int y, int z, @NotNull Random rand, boolean isRandomTick) {
        this.updateTick(world, new TilePos(x, y, z), rand, isRandomTick);
    }

    public void animationTick(@NotNull World var1, @NotNull TilePosc var2, @NotNull Random var3);

    @Deprecated
    default public void animationTick(@NotNull World world, int x, int y, int z, @NotNull Random rand) {
        this.animationTick(world, new TilePos(x, y, z), rand);
    }

    public void onNeighborChanged(@NotNull World var1, @NotNull TilePosc var2, int var3);

    @Deprecated
    default public void onNeighborBlockChange(@NotNull World world, int x, int y, int z, int id) {
        this.onNeighborChanged(world, new TilePos(x, y, z), id);
    }

    public int tickDelay();

    public void onPlacedByWorld(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public void onBlockPlacedByWorld(@NotNull World world, int x, int y, int z) {
        this.onPlacedByWorld(world, new TilePos(x, y, z));
    }

    public void onRemoved(@NotNull World var1, @NotNull TilePosc var2, int var3);

    @Deprecated
    default public void onBlockRemoved(@NotNull World world, int x, int y, int z, int data) {
        this.onRemoved(world, new TilePos(x, y, z), data);
    }

    public void onDestroyedByPlayer(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3, int var4, @NotNull Player var5, @Nullable Item var6);

    @Deprecated
    default public void onBlockDestroyedByPlayer(@NotNull World world, int x, int y, int z, @NotNull Side side, int data, @NotNull Player player, @Nullable Item item) {
        this.onDestroyedByPlayer(world, new TilePos(x, y, z), side, data, player, item);
    }

    public float getStrength(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3, @NotNull Player var4);

    @Deprecated
    default public float blockStrength(@NotNull World world, int x, int y, int z, @NotNull Side side, @NotNull Player player) {
        return this.getStrength(world, new TilePos(x, y, z), side, player);
    }

    public boolean getImmovable();

    public float getBlastResistance(@Nullable Entity var1);

    @Nullable
    public HitResult collisionRayTrace(@NotNull World var1, @NotNull TilePosc var2, @NotNull Vector3dc var3, @NotNull Vector3dc var4, boolean var5);

    @Deprecated
    @Nullable
    default public HitResult collisionRayTrace(@NotNull World world, int x, int y, int z, @NotNull Vector3dc start, @NotNull Vector3dc end, boolean useSelectionAABB) {
        return this.collisionRayTrace(world, new TilePos(x, y, z), start, end, useSelectionAABB);
    }

    public void onDestroyedByExplosion(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public void onBlockDestroyedByExplosion(@NotNull World world, int x, int y, int z) {
        this.onDestroyedByExplosion(world, new TilePos(x, y, z));
    }

    public boolean canPlaceOnSide(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3);

    @Deprecated
    default public boolean canPlaceBlockOnSide(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return this.canPlaceOnSide(world, new TilePos(x, y, z), side);
    }

    public boolean canPlaceAt(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public boolean canPlaceBlockAt(@NotNull World world, int x, int y, int z) {
        return this.canPlaceAt(world, new TilePos(x, y, z));
    }

    public boolean onInteracted(@NotNull World var1, @NotNull TilePosc var2, @NotNull Player var3, @Nullable Side var4, double var5, double var7);

    @Deprecated
    default public boolean onBlockRightClicked(@NotNull World world, int x, int y, int z, @Nullable Player player, @Nullable Side side, double xHit, double yHit) {
        return this.onInteracted(world, new TilePos(x, y, z), player, side, xHit, yHit);
    }

    public void onActivatorInteracted(@NotNull World var1, @NotNull TilePosc var2, @NotNull TileEntityActivator var3, @NotNull Direction var4);

    @Deprecated
    default public void onActivatorInteract(@NotNull World world, int x, int y, int z, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.onActivatorInteracted(world, new TilePos(x, y, z), activator, direction);
    }

    public void onEntityWalkedOn(@NotNull World var1, @NotNull TilePosc var2, @NotNull Entity var3);

    @Deprecated
    default public void onEntityWalking(@NotNull World world, int x, int y, int z, @NotNull Entity entity) {
        this.onEntityWalkedOn(world, new TilePos(x, y, z), entity);
    }

    public void onAttacked(@NotNull World var1, @NotNull TilePosc var2, @NotNull Player var3, @NotNull Side var4, double var5, double var7);

    @Deprecated
    default public void onBlockLeftClicked(@NotNull World world, int x, int y, int z, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        this.onAttacked(world, new TilePos(x, y, z), player, side, xHit, yHit);
    }

    public void onEntityInside(@NotNull World var1, @NotNull TilePosc var2, @NotNull Entity var3, @NotNull Vector3d var4);

    @Deprecated
    default public void handleEntityInside(@NotNull World world, int x, int y, int z, @NotNull Entity entity, @NotNull Vector3d velocityDirection) {
        this.onEntityInside(world, new TilePos(x, y, z), entity, velocityDirection);
    }

    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    @NotNull
    default public AABBdc getBlockBoundsFromState(@NotNull WorldSource world, int x, int y, int z) {
        return this.getBoundsFromState(world, new TilePos(x, y, z));
    }

    public boolean isEmittingSignal(@NotNull WorldSource var1, @NotNull TilePosc var2, @NotNull Side var3);

    @Deprecated
    default public boolean getSignal(@NotNull WorldSource source, int x, int y, int z, @NotNull Side side) {
        return this.isEmittingSignal(source, new TilePos(x, y, z), side);
    }

    public boolean isSignalSource();

    public void onEntityCollision(@NotNull World var1, @NotNull TilePosc var2, @NotNull Entity var3);

    @Deprecated
    default public void onEntityCollidedWithBlock(@NotNull World world, int x, int y, int z, @NotNull Entity entity) {
        this.onEntityCollision(world, new TilePos(x, y, z), entity);
    }

    public boolean isEmittingDirectSignal(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3);

    @Deprecated
    default public boolean getDirectSignal(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return this.isEmittingDirectSignal(world, new TilePos(x, y, z), side);
    }

    public void onHarvest(@NotNull World var1, @NotNull Player var2, @NotNull TilePosc var3, int var4, @Nullable TileEntity var5);

    @Deprecated
    default public void harvestBlock(@NotNull World world, @NotNull Player player, int x, int y, int z, int data, @Nullable TileEntity tileEntity) {
        this.onHarvest(world, player, new TilePos(x, y, z), data, tileEntity);
    }

    public void dropWithCause(@NotNull World var1, @NotNull EnumDropCause var2, @NotNull TilePosc var3, int var4, @Nullable TileEntity var5, @Nullable Player var6);

    @Deprecated
    default public void dropBlockWithCause(@NotNull World world, @NotNull EnumDropCause dropCause, int x, int y, int z, int data, @Nullable TileEntity tileEntity, @Nullable Player player) {
        this.dropWithCause(world, dropCause, new TilePos(x, y, z), data, tileEntity, player);
    }

    @NotNull
    public ISupport getSupport(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3);

    @Deprecated
    @NotNull
    default public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return this.getSupport(world, new TilePos(x, y, z), side);
    }

    public boolean canStay(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public boolean canBlockStay(@NotNull World world, int x, int y, int z) {
        return this.canStay(world, new TilePos(x, y, z));
    }

    public void onPlacedByMob(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3, @NotNull Mob var4, double var5, double var7);

    @Deprecated
    default public void onBlockPlacedByMob(@NotNull World world, int x, int y, int z, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        this.onPlacedByMob(world, new TilePos(x, y, z), side, mob, xHit, yHit);
    }

    public void onPlacedOnSide(@NotNull World var1, @NotNull TilePosc var2, @NotNull Side var3, double var4, double var6);

    @Deprecated
    default public void onBlockPlacedOnSide(@NotNull World world, int x, int y, int z, @NotNull Side side, double xHit, double yHit) {
        this.onPlacedOnSide(world, new TilePos(x, y, z), side, xHit, yHit);
    }

    @NotNull
    public String getLanguageKey(int var1);

    public void triggerEvent(@NotNull World var1, @NotNull TilePosc var2, int var3, int var4);

    @Deprecated
    default public void triggerEvent(@NotNull World world, int x, int y, int z, int index, int data) {
        this.triggerEvent(world, new TilePos(x, y, z), index, data);
    }

    public int getPistonPushReaction(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public int getPistonPushReaction(@NotNull World world, int x, int y, int z) {
        return this.getPistonPushReaction(world, new TilePos(x, y, z));
    }

    public int getPlacedData(@Nullable Player var1, @NotNull ItemStack var2, @NotNull World var3, @NotNull TilePosc var4, @NotNull Side var5, double var6, double var8);

    @Deprecated
    default public int getPlacedBlockMetadata(@Nullable Player player, @NotNull ItemStack stack, @NotNull World world, int x, int y, int z, @NotNull Side side, double xHit, double yHit) {
        return this.getPlacedData(player, stack, world, new TilePos(x, y, z), side, xHit, yHit);
    }

    public boolean isClimbable(@NotNull World var1, @NotNull TilePosc var2);

    @Deprecated
    default public boolean isClimbable(@NotNull World world, int x, int y, int z) {
        return this.isClimbable(world, new TilePos(x, y, z));
    }

    public boolean isEquivalent(@NotNull World var1, @NotNull TilePosc var2, @NotNull TilePosc var3);

    @Deprecated
    default public boolean isEquivalent(@NotNull World world, int thisX, int thisY, int thisZ, int thatX, int thatY, int thatZ) {
        return this.isEquivalent(world, new TilePos(thisX, thisY, thisZ), new TilePos(thatX, thatY, thatZ));
    }

    @NotNull
    public Side getAttachedSide(@NotNull WorldSource var1, @NotNull TilePosc var2);

    @Deprecated
    @NotNull
    default public Side getAttachedSide(@NotNull WorldSource source, int x, int y, int z) {
        return this.getAttachedSide(source, new TilePos(x, y, z));
    }
}

