/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemTool;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemToolHoe
extends ItemTool {
    public ItemToolHoe(@NotNull String name, @NotNull String namespaceId, int id, @NotNull ToolMaterial toolMaterial) {
        super(name, namespaceId, id, 3, toolMaterial, BlockTags.MINEABLE_BY_HOE);
        this.maxStackSize = 1;
        this.setMaxDamage(toolMaterial.getDurability());
    }

    @Override
    public boolean canHarvestBlock(@NotNull ItemStack selfStack, @NotNull Mob mob, @NotNull Block<?> block) {
        return block.hasTag(BlockTags.MINEABLE_BY_HOE);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        return this.till(selfStack, player, world, blockPos, side);
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        this.till(selfStack, null, world, blockPos.add(direction, new TilePos()), direction.getSide());
    }

    public boolean till(@NotNull ItemStack selfStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc blockPos, @NotNull Side side) {
        int id = world.getBlockId(blockPos);
        int idAbove = world.getBlockId(blockPos.up(new TilePos()));
        if (side != Side.BOTTOM && idAbove == 0 && (id == Blocks.GRASS.id() || id == Blocks.DIRT.id() || id == Blocks.PATH_DIRT.id() || id == Blocks.GRASS_RETRO.id() || id == Blocks.MUD.id())) {
            int meta = 0;
            if (id == Blocks.MUD.id()) {
                meta = 1;
            }
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.DIRT, EnumBlockSoundEffectType.MINE);
            if (!(world.isClientSide || id != Blocks.GRASS.id() && id != Blocks.GRASS_RETRO.id() && id != Blocks.GRASS_SCORCHED.id() || world.rand.nextInt(5) != 0)) {
                world.dropItem(blockPos.up(new TilePos()), new ItemStack(Items.SEEDS_WHEAT));
            }
            if (!world.isClientSide) {
                world.setBlockIdDataNotify(blockPos, Blocks.FARMLAND_DIRT.id(), meta);
                selfStack.damageItem(1, player);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockDestroyed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Mob mob, @NotNull Block<?> removedBlock, @NotNull TilePos blockPos, @NotNull Side side) {
        if (!(world.isClientSide || removedBlock != Blocks.TALLGRASS && removedBlock != Blocks.TALLGRASS_FERN)) {
            if (this.material.isSilkTouch()) {
                world.dropItem(blockPos, new ItemStack(removedBlock));
                selfStack.damageItem(1, mob);
            } else if (world.rand.nextInt(4) == 0) {
                world.dropItem(blockPos, new ItemStack(Items.SEEDS_WHEAT));
                selfStack.damageItem(1, mob);
            }
        }
        return super.onBlockDestroyed(selfStack, world, mob, removedBlock, blockPos, side);
    }
}

