#version 410 core
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

in VS_OUT {
    vec2 size;
    float shift;
    vec4 color;
    vec2 uv;
    vec2 uvSizes;
    vec2 lightmap;
} gs_in[];

out vec4 Color;
out vec2 TexCoord;
out vec2 Lightmap;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main() {
    Color = gs_in[0].color;
    Lightmap = gs_in[0].lightmap;

    TexCoord = gs_in[0].uv + vec2(0, gs_in[0].uvSizes.y);
    gl_Position = projection * view * model * (gl_in[0].gl_Position + vec4(-gs_in[0].shift,  gs_in[0].size.y, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(gs_in[0].uvSizes.x, gs_in[0].uvSizes.y);
    gl_Position = projection * view * model * (gl_in[0].gl_Position + vec4(gs_in[0].size.x - gs_in[0].shift,  gs_in[0].size.y, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(0, 0);
    gl_Position = projection * view * model * (gl_in[0].gl_Position + vec4(gs_in[0].shift, 0, 0.0, 0.0));
    EmitVertex();

    TexCoord = gs_in[0].uv + vec2(gs_in[0].uvSizes.x, 0);
    gl_Position = projection * view * model * (gl_in[0].gl_Position + vec4(gs_in[0].size.x + gs_in[0].shift, 0, 0.0, 0.0));
    EmitVertex();

    EndPrimitive();
}