#version 410 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec4 aColor;
layout (location = 2) in vec2 aUV;
layout (location = 3) in vec2 aLightmap;
layout (location = 4) in vec3 aNormal;

out vec4 Color;
out vec2 TexCoord;
out vec2 LightMapCoord;
out float Distance;
out vec3 Light;

uniform mat4 normalTransform;
uniform vec4 lightModelAmbient;
uniform vec4 lightSourcePosition[];
uniform vec4 lightSourceDiffuse[];

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main() {
    vec4 p = vec4(aPos, 1);
    gl_Position = projection * view * model * p;

    TexCoord = aUV;
    Color = aColor;
    LightMapCoord = aLightmap;

    // Used for the radial fog in shader
    Distance = length((view * model * p).xyz);

    vec4 norm = normalize(normalTransform * model * vec4(aNormal, 0));
    float dir1 = max(0.0f, dot(norm, lightSourcePosition[0]));
    float dir2 = max(0.0f, dot(norm, lightSourcePosition[1]));
    Light = (lightModelAmbient + lightSourceDiffuse[0] * (dir1 + dir2)).xyz;
}
