/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.material.Materials;

public class HudComponentOxygenBar
extends HudComponentMovable {
    private final IconCoordinate air = TextureRegistry.getTexture("minecraft:gui/hud/air");
    private final IconCoordinate air_pop = TextureRegistry.getTexture("minecraft:gui/hud/air_pop");

    public HudComponentOxygenBar(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible() {
        return HudComponentOxygenBar.mc.gameSettings.immersiveMode.drawHotbar() && HudComponentOxygenBar.mc.playerController.canHurtPlayer() && !HudComponentOxygenBar.mc.thePlayer.getGamemode().isPlayerInvulnerable() && HudComponentOxygenBar.mc.thePlayer.isUnderLiquid(Materials.WATER);
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        int numBubbles = (int)Math.ceil((double)(HudComponentOxygenBar.mc.thePlayer.airSupply - 2) * 10.0 / 300.0);
        int numPops = (int)Math.ceil((double)HudComponentOxygenBar.mc.thePlayer.airSupply * 10.0 / 300.0) - numBubbles;
        for (int i = 0; i < numBubbles + numPops; ++i) {
            if (i < numBubbles) {
                hud.drawGuiIcon(x + i * 8, y, 9, 9, this.air);
                continue;
            }
            hud.drawGuiIcon(x + i * 8, y, 9, 9, this.air_pop);
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(this, xSizeScreen);
        int y = layout.getComponentY(this, ySizeScreen);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.enableState(State.BLEND);
        int numBubbles = 5;
        int numPops = 6 - numBubbles;
        for (int i = 0; i < numBubbles + numPops; ++i) {
            if (i < numBubbles) {
                gui.drawGuiIcon(x + i * 8, y, 9, 9, this.air);
                continue;
            }
            gui.drawGuiIcon(x + i * 8, y, 9, 9, this.air_pop);
        }
    }
}

