/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class BlockModelPumice<T extends BlockLogic>
extends BlockModelStandard<T> {
    private boolean lavaFlag = false;

    public BlockModelPumice(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        this.lavaFlag = true;
        boolean ob = BlockModelPumice.renderBlocks.overbright;
        BlockModelPumice.renderBlocks.overbright = true;
        boolean rendered = super.render(tessellator, worldSource, tilePos);
        BlockModelPumice.renderBlocks.overbright = ob;
        this.lavaFlag = false;
        return rendered |= super.render(tessellator, worldSource, tilePos);
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        int color = this.getStandaloneTintColor(metadata);
        this.lavaFlag = true;
        boolean ob = BlockModelPumice.renderBlocks.overbright;
        BlockModelPumice.renderBlocks.overbright = true;
        double depthFixOffset = 0.001;
        AABBd bounds = new AABBd(0.001, 0.001, 0.001, 0.999, 0.999, 0.999);
        this.renderBlockWithBounds(tessellator, bounds, metadata, LightmapHelper.getLightmapCoord(15, 15), color);
        BlockModelPumice.renderBlocks.overbright = ob;
        this.lavaFlag = false;
        bounds.setMin(0.0, 0.0, 0.0).setMax(1.0, 1.0, 1.0);
        this.renderBlockWithBounds(tessellator, bounds, metadata, lightmapCoord, color);
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (this.lavaFlag) {
            return TextureRegistry.getTexture("minecraft:block/lava_still");
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(@NotNull Side side, int data) {
        if (this.lavaFlag) {
            return TextureRegistry.getTexture("minecraft:block/lava_still");
        }
        return super.getBlockOverbrightTextureFromSideAndMeta(side, data);
    }
}

