/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelSlab;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSlab;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelSlabMarble<T extends BlockLogicSlab>
extends BlockModelSlab<T> {
    protected IconCoordinate slabSide = TextureRegistry.getTexture("minecraft:block/carved_marble");

    public BlockModelSlabMarble(Block<T> block) {
        super(block);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, source.getBlockData(tilePos));
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (data != 1 && side.getAxis() != Axis.Y) {
            return this.slabSide;
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }
}

