/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererGhast
extends MobRenderer<MobGhast> {
    public MobRendererGhast(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobGhast entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        BoneTransform body = model.getTransform("body");
        float charge = MathHelper.lerp(entity.attackChargeO, entity.attackCharge, partialTick) / 20.0f;
        if (charge < 0.0f) {
            charge = 0.0f;
        }
        charge = 1.0f / (charge * charge * charge * charge * charge * 2.0f + 1.0f);
        float sHeight = (8.0f + charge) / 2.0f;
        float sWidth = (8.0f + 1.0f / charge) / 2.0f;
        float limbPitch = this.getLimbPitch(entity, partialTick);
        body.scaleX = sWidth;
        body.scaleY = sHeight;
        body.scaleZ = sWidth;
        model.getTransform((String)"tentacles_0").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 0.0f) + 0.4f;
        model.getTransform((String)"tentacles_1").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 1.0f) + 0.4f;
        model.getTransform((String)"tentacles_2").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 2.0f) + 0.4f;
        model.getTransform((String)"tentacles_3").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 3.0f) + 0.4f;
        model.getTransform((String)"tentacles_4").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 4.0f) + 0.4f;
        model.getTransform((String)"tentacles_5").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 5.0f) + 0.4f;
        model.getTransform((String)"tentacles_6").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 6.0f) + 0.4f;
        model.getTransform((String)"tentacles_7").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 7.0f) + 0.4f;
        model.getTransform((String)"tentacles_8").rotX = 0.2f * MathHelper.sin(limbPitch * 0.3f + 8.0f) + 0.4f;
        return model;
    }

    @Override
    public void renderPreview(@NotNull TessellatorGeneral tessellator, @NotNull MobGhast mobGhast, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate(0.0f, 1.0f, 0.0f);
        GLRenderer.modelM4f().scale(0.25f, 0.25f, 0.25f);
        super.renderPreview(tessellator, mobGhast, x, y, z, yaw, partialTick);
        GLRenderer.popFrame();
    }
}

