/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.FrontFace;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public abstract class ItemModel {
    public Item item;

    public ItemModel(Item item) {
        this.item = item;
    }

    public abstract void render(@NotNull TessellatorGeneral var1, @Nullable Entity var2, @NotNull ItemStack var3, @NotNull String var4, boolean var5, int var6, int var7, float var8, boolean var9);

    public abstract void renderItemOverlayIntoGUI(@NotNull TessellatorGeneral var1, @NotNull FontRenderer var2, @NotNull TextureManager var3, @NotNull ItemStack var4, int var5, int var6, @Nullable String var7, float var8);

    public void renderGui(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, int x, int y, int lightmapCoord, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.modelM4f().translate(x + 8, y + 8, 0.0f);
        GLRenderer.modelM4f().scale(16.0f, -16.0f, 1.0f);
        this.render(tessellator, holder, itemStack, "gui", false, 1, LightmapHelper.getLightmapCoord(15, 15), partialTick, false);
        GLRenderer.globalSetLightEnabled(true);
        GLRenderer.popFrame();
    }

    public void renderItemEntity(@NotNull TessellatorGeneral tessellator, @NotNull ItemStack itemStack, boolean items3d, int clusterSize, int ticks, float yaw, int lightmap, float partialTick) {
        GLRenderer.enableState(State.BLEND);
        if (items3d) {
            GLRenderer.modelM4f().rotateY(Math.toRadians(yaw));
        } else {
            GLRenderer.modelM4f().rotateY(Math.toRadians(180.0f - EntityRendererDispatcher.instance.viewLerpYaw));
        }
        this.render(tessellator, null, itemStack, "ground", items3d, clusterSize, lightmap, partialTick, false);
        GLRenderer.disableState(State.BLEND);
    }

    public void renderFirstPerson(@NotNull TessellatorGeneral tessellator, @NotNull ItemRenderer itemRenderer, @NotNull Player player, @NotNull ItemStack itemStack, int lightmapCoord, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.enableState(State.CULL_FACE);
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin(swingProgress * (float)java.lang.Math.PI);
        float animationProgress = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI);
        if (player.isLeftHanded()) {
            float xOff = 0.5625f;
            float yOff = -0.515625f - (1.0f - itemRenderer.getEquippedProgress(partialTick)) * 0.6f;
            float zOff = -0.725f;
            GLRenderer.modelM4f().scale(-1.0f, 1.0f, 1.0f);
            GLRenderer.modelM4f().translate(-animationProgress * 0.4f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI * 2.0f) * 0.2f, -animationProgress2 * 0.2f);
            GLRenderer.modelM4f().translate(0.5625f, yOff, -0.725f);
            float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)java.lang.Math.PI);
            GLRenderer.modelM4f().rotateY(Math.toRadians(45.0f));
            GLRenderer.modelM4f().rotateY(Math.toRadians(-animationProgress3) * 20.0f);
            GLRenderer.modelM4f().rotateZ(Math.toRadians(-animationProgress) * 20.0f);
            GLRenderer.modelM4f().rotateX(Math.toRadians(-animationProgress) * 80.0f);
            GLRenderer.modelM4f().rotateY(Math.toRadians(-45.0f));
            GLRenderer.setFrontFace(FrontFace.CW);
            this.render(tessellator, player, itemStack, "firstperson_lefthand", true, 1, lightmapCoord, partialTick, true);
            GLRenderer.setFrontFace(FrontFace.CCW);
        } else {
            float xOff = 0.5625f;
            float yOff = -0.515625f - (1.0f - itemRenderer.getEquippedProgress(partialTick)) * 0.6f;
            float zOff = -0.725f;
            GLRenderer.modelM4f().translate(-animationProgress * 0.4f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI * 2.0f) * 0.2f, -animationProgress2 * 0.2f);
            GLRenderer.modelM4f().translate(0.5625f, yOff, -0.725f);
            float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)java.lang.Math.PI);
            GLRenderer.modelM4f().rotateY(Math.toRadians(45.0f));
            GLRenderer.modelM4f().rotateY(Math.toRadians(-animationProgress3) * 20.0f);
            GLRenderer.modelM4f().rotateZ(Math.toRadians(-animationProgress) * 20.0f);
            GLRenderer.modelM4f().rotateX(Math.toRadians(-animationProgress) * 80.0f);
            GLRenderer.modelM4f().rotateY(Math.toRadians(-45.0f));
            this.render(tessellator, player, itemStack, "firstperson_righthand", true, 1, lightmapCoord, partialTick, false);
        }
        GLRenderer.popFrame();
    }

    public abstract IconCoordinate getIcon(@Nullable Entity var1, ItemStack var2);
}

