/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.useless.dragonfly.DisplayPos;

public class ItemModelBlock
extends ItemModelStandard {
    private final Block<?> block;
    private final BlockModel<?> blockModel;

    public ItemModelBlock(ItemBlock<?> itemBlock) {
        super(itemBlock, null);
        this.block = itemBlock.getBlock();
        this.blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        this.icon = this.blockModel.getOverlayTexture(0);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        IconCoordinate overlay = this.blockModel.getOverlayTexture(itemStack.getMetadata());
        return overlay != null ? overlay : BlockModelStandard.BLOCK_TEXTURE_UNASSIGNED;
    }

    @Override
    @NotNull
    public DisplayPos getDisplayPos(@NotNull String id) {
        return this.blockModel.shouldItemRender3d() ? this.blockModel.getItemDisplayPos(id) : super.getDisplayPos(id);
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, @NotNull String displayPosId, boolean items3d, int clusterSize, int lightmapCoord, float partialTick, boolean mirrorX) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.render(tessellator, holder, itemStack, displayPosId, items3d, clusterSize, lightmapCoord, partialTick, mirrorX);
            return;
        }
        random.setSeed(187L);
        DisplayPos displayPos = this.getDisplayPos(displayPosId);
        GLRenderer.modelM4f().translate(displayPos.tx, displayPos.ty, displayPos.tz);
        GLRenderer.modelM4f().rotateX(Math.toRadians(displayPos.rx));
        GLRenderer.modelM4f().rotateY(Math.toRadians(displayPos.ry));
        GLRenderer.modelM4f().rotateZ(Math.toRadians(displayPos.rz));
        GLRenderer.modelM4f().scale(displayPos.sx, displayPos.sy, displayPos.sz);
        for (int i = 0; i < clusterSize; ++i) {
            float rOffX = 0.0f;
            float rOffY = 0.0f;
            float rOffZ = 0.0f;
            if (i > 0) {
                rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sx;
                rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sy;
                rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sz;
            }
            GLRenderer.modelM4f().translate(rOffX, rOffY, rOffZ);
            this.renderSingle(tessellator, holder, itemStack, items3d, lightmapCoord, this.getColor(itemStack), partialTick, mirrorX);
            GLRenderer.modelM4f().translate(-rOffX, -rOffY, -rOffZ);
        }
    }

    @Override
    protected void renderSingle(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, boolean items3d, int lightmapCoord, int color, float partialTick, boolean mirrorX) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.renderSingle(tessellator, holder, itemStack, items3d, lightmapCoord, color, partialTick, mirrorX);
        } else {
            TextureRegistry.worldAtlas.bind();
            this.blockModel.renderStandalone(tessellator, itemStack.getMetadata(), lightmapCoord);
        }
    }

    @Override
    public void renderGui(@NotNull TessellatorGeneral tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, int x, int y, int lightmapCoord, float partialTick) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.renderGui(tessellator, holder, itemStack, x, y, lightmapCoord, partialTick);
            return;
        }
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.modelM4f().translate(x + 8, y + 8, 8.0f);
        GLRenderer.modelM4f().scale(16.0f, -16.0f, 16.0f);
        this.render(tessellator, holder, itemStack, "gui", false, 1, lightmapCoord, partialTick, false);
        GLRenderer.popFrame();
    }

    @Override
    public void renderItemEntity(@NotNull TessellatorGeneral tessellator, @NotNull ItemStack itemStack, boolean items3d, int clusterSize, int ticks, float yaw, int lightmap, float partialTick) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.renderItemEntity(tessellator, itemStack, items3d, clusterSize, ticks, yaw, lightmap, partialTick);
            return;
        }
        GLRenderer.enableState(State.BLEND);
        GLRenderer.modelM4f().rotateY(Math.toRadians(yaw));
        this.render(tessellator, null, itemStack, "ground", items3d, clusterSize, lightmap, partialTick, false);
        GLRenderer.disableState(State.BLEND);
    }

    @Override
    public int getColor(ItemStack stack) {
        return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(stack.getMetadata(), 0);
    }
}

