/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.core.util.helper.Buffer;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class TessellatorParticleShader
implements TessellatorParticle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean drawing = false;
    private ByteBuffer buffer;
    private int count = 0;
    private final int vao;
    private final int vbo;
    private int color;
    private int lightmapCoord;
    private double offsetX;
    private double offsetY;
    private double offsetZ;

    public TessellatorParticleShader(int size) {
        this.buffer = Buffer.createBuffer(size);
        this.vao = GL41.glGenVertexArrays();
        this.vbo = GL41.glGenBuffers();
        GL41.glBindVertexArray(this.vao);
        GL41.glBindBuffer(34962, this.vbo);
        int offset = 0;
        int vertexSize = 38;
        GL41.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
        GL41.glVertexAttribPointer(1, 1, 5126, false, vertexSize, offset += 12);
        GL41.glVertexAttribPointer(2, 4, 5121, true, vertexSize, offset += 4);
        GL41.glVertexAttribPointer(3, 2, 5126, false, vertexSize, offset += 4);
        GL41.glVertexAttribPointer(4, 2, 5126, false, vertexSize, offset += 8);
        GL41.glVertexAttribPointer(5, 2, 5121, true, vertexSize, offset += 8);
        offset += 2;
        GL41.glEnableVertexAttribArray(0);
        GL41.glEnableVertexAttribArray(1);
        GL41.glEnableVertexAttribArray(2);
        GL41.glEnableVertexAttribArray(3);
        GL41.glEnableVertexAttribArray(4);
        GL41.glEnableVertexAttribArray(5);
        GL41.glBindBuffer(34962, 0);
        GL41.glBindVertexArray(0);
    }

    @Override
    public void startDrawingParticles() {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing!");
        }
        this.drawing = true;
        this.color = -1;
        this.lightmapCoord = LightmapHelper.getLightmapCoord(15, 15);
        this.count = 0;
        this.buffer.clear();
    }

    @Override
    public void setLightmapCoord1i(int lightmapCoord) {
        this.checkIsDrawing();
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void addParticle(double x, double y, double z, float scale, double u, double v, double uSize, double vSize) {
        this.checkIsDrawing();
        if (this.buffer.capacity() < this.buffer.position() + 64) {
            int newSize = this.buffer.capacity() * 2;
            LOGGER.info("Expanding Particle Tessellator Buffer ({} -> {})", (Object)this.buffer.capacity(), (Object)newSize);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        this.buffer.putFloat((float)(x + this.offsetX)).putFloat((float)(y + this.offsetY)).putFloat((float)(z + this.offsetZ)).putFloat(scale);
        this.buffer.putInt(this.color);
        this.buffer.putFloat((float)u).putFloat((float)v);
        this.buffer.putFloat((float)uSize).putFloat((float)vSize);
        this.buffer.put((byte)((LightmapHelper.getBlockLightFromCoord(this.lightmapCoord) << 4) + 7)).put((byte)((LightmapHelper.getSkyLightFromCoord(this.lightmapCoord) << 4) + 7));
        ++this.count;
    }

    @Override
    public void drawParticles() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.count == 0) {
            return;
        }
        GL41.glBindVertexArray(this.vao);
        GL41.glBindBuffer(34962, this.vbo);
        GL41.glBufferData(34962, this.buffer.flip(), 35040);
        GLRenderer.render(this.vao, this.vbo, 0, this.count, DrawMode.POINTS);
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    @Override
    public void setColorOpaque3i(int r, int g, int b) {
        this.setColor4i(r, g, b, 255);
    }

    @Override
    public void setColorOpaque3f(float r, float g, float b) {
        this.setColorOpaque3i((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    @Override
    public void setColorOpaque1i(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.setColorOpaque3i(r, g, b);
    }

    @Override
    public void setColor4f(float r, float g, float b, float a) {
        this.setColor4i((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    @Override
    public void setColor2i(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.setColor4i(r, g, b, a);
    }

    @Override
    public void setupParticleValues(@NotNull ICamera camera, float partialTick) {
    }

    @Override
    public void setColor4i(int r, int g, int b, int a) {
        this.checkIsDrawing();
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        a = MathHelper.clamp(a, 0, 255);
        this.color = a << 24 | b << 16 | g << 8 | r;
    }
}

