/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.minecraft.client.render.texture.meta.TextureMetaHandler;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class IconCoordinate
implements Comparable<IconCoordinate> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public int iconX;
    public int iconY;
    public int width;
    public int height;
    private double uMin;
    private double uMax;
    private double vMin;
    private double vMax;
    private double uSize;
    private double vSize;
    private boolean pendingDimensions;
    @NotNull
    protected final String sourceImagePath;
    @NotNull
    protected final TextureMetaHandler metaHandler = new TextureMetaHandler();
    @NotNull
    public final NamespaceID namespaceId;
    @NotNull
    public final AtlasStitcher parentAtlas;
    private BufferedImage _imageStorage;

    public IconCoordinate(@NotNull AtlasStitcher stitcher, @NotNull NamespaceID namespaceId, @NotNull String sourceImagePath) {
        this.parentAtlas = stitcher;
        this.namespaceId = namespaceId;
        this.sourceImagePath = sourceImagePath;
    }

    protected void setImage(@NotNull BufferedImage image) {
        assert (image != null) : "setImage cannot take null!";
        this.pendingDimensions = true;
        this._imageStorage = image;
    }

    public BufferedImage getImageStorage() {
        return this._imageStorage;
    }

    protected void discardImage() {
        this.uMin = (double)this.iconX * this.parentAtlas.getInverseWidth();
        this.uMax = ((double)this.iconX + (double)this.width) * this.parentAtlas.getInverseWidth();
        this.vMin = (double)this.iconY * this.parentAtlas.getInverseHeight();
        this.vMax = ((double)this.iconY + (double)this.height) * this.parentAtlas.getInverseHeight();
        this.uSize = (double)this.width * this.parentAtlas.getInverseWidth();
        this.vSize = (double)this.height * this.parentAtlas.getInverseHeight();
        this._imageStorage = null;
    }

    public boolean needsDimensions() {
        return this.pendingDimensions;
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        this.pendingDimensions = false;
    }

    public void setPosition(int x, int y) {
        this.iconX = x;
        this.iconY = y;
    }

    public int getArea() {
        return this.width * this.height;
    }

    protected void drawToAtlas(Graphics2D atlas) {
        assert (this._imageStorage != null) : "Image storage should not be null!! something went wrong with image '" + String.valueOf(this.namespaceId) + "' at '" + this.sourceImagePath + "'!";
        if (this.width != this._imageStorage.getWidth() || this.height != this._imageStorage.getHeight()) {
            int[] subImage = this._imageStorage.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            BufferedImage _img = new BufferedImage(this.width, this.height, 2);
            _img.setRGB(0, 0, this.width, this.height, subImage, 0, this.width);
            atlas.drawImage((Image)_img, this.iconX, this.iconY, null);
            return;
        }
        atlas.drawImage((Image)this._imageStorage, this.iconX, this.iconY, null);
    }

    public double getIconUMin() {
        return this.uMin;
    }

    public double getIconUMax() {
        return this.uMax;
    }

    public double getIconVMin() {
        return this.vMin;
    }

    public double getIconVMax() {
        return this.vMax;
    }

    public double getSubIconU(double offset) {
        return this.uMin + this.uSize * offset;
    }

    public double getSubIconV(double offset) {
        return this.vMin + this.vSize * offset;
    }

    public double getIconUSize() {
        return this.uSize;
    }

    public double getIconVSize() {
        return this.vSize;
    }

    public String toString() {
        return String.format("W:%d, H:%d, X:%d, Y:%d | ID:%s, Source:%s", this.width, this.height, this.iconX, this.iconY, this.namespaceId, this.sourceImagePath);
    }

    public String getImageSource() {
        return this.sourceImagePath;
    }

    @Override
    public int compareTo(@NotNull IconCoordinate o) {
        int res = o.height - this.height;
        if (res != 0) {
            return res;
        }
        return this.namespaceId.compareTo(o.namespaceId);
    }

    protected void resetMetadata() {
        this.metaHandler.reset();
    }

    protected void initMetadata(InputStream stream) {
        try {
            this.metaHandler.loadFromStream(stream);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load metadata for '{}'!", (Object)this.namespaceId, (Object)e);
        }
    }

    public boolean hasMeta(String key) {
        return this.metaHandler.has(key);
    }

    @Nullable
    public <T> T getMeta(String key, Class<T> aClass) {
        return this.metaHandler.get(key, aClass);
    }

    public <T> T getOrDefaultMeta(String key, T metaDefault, Class<T> aClass) {
        return this.metaHandler.getOrDefault(key, metaDefault, aClass);
    }
}

