/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWKeyboardImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWMouseImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.CombinedInputImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import com.mojang.logging.LogUtils;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.client.util.debug.GLFWLoggerCallback;
import net.minecraft.client.util.debug.OpenGLLoggerCallback;
import net.minecraft.core.BuildChannel;
import net.minecraft.core.Global;
import net.minecraft.core.UnexpectedThrowable;
import net.minecraft.core.Version;
import net.minecraft.core.enums.EnumOS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class GameWindowGLFW
implements GameWindow {
    public static final Logger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    public long window;
    private boolean wasResized = false;
    private boolean isFullscreen = false;
    private boolean hasFocus = true;
    private int windowPosX;
    private int windowPosY;
    private int windowWidth;
    private int windowHeight;
    private int widthScreenCoords;
    private int heightScreenCoords;
    private int widthPixels;
    private int heightPixels;
    private final Map<CursorShape, Long> cursors = new HashMap<CursorShape, Long>();
    private CursorShape currentCursor = CursorShape.ARROW;
    @NotNull
    private final @NotNull List<@NotNull ByteBuffer> stbiIconImages = new ArrayList<ByteBuffer>();
    @Nullable
    private GLFWErrorCallback glfwErrorCallback;
    @Nullable
    private GLDebugMessageCallback glDebugMessageCallback;

    @Override
    public void init(Minecraft minecraft, int width, int height) {
        block22: {
            this.mc = minecraft;
            boolean debug = (Boolean)this.mc.gameSettings.developerMode.value != false || Version.BUILD_CHANNEL == BuildChannel.DEVELOPMENT || Global.DEBUG_MODE;
            LOGGER.info("Initializing GLFW...");
            if (debug) {
                this.glfwErrorCallback = GLFWErrorCallback.create(new GLFWLoggerCallback()).set();
            }
            if (!GLFW.glfwInit()) {
                throw new RuntimeException("GLFW initialization failed!");
            }
            GLFW.glfwWindowHint(131075, 1);
            GLFW.glfwWindowHint(131076, 0);
            GLFW.glfwWindowHint(131078, 1);
            GLFW.glfwWindowHint(131077, 1);
            GLFW.glfwWindowHint(139270, 1);
            for (int i = 0; i < OpenGLHelper.versionPairs.length; i += 2) {
                GLFW.glfwWindowHint(139266, OpenGLHelper.versionPairs[i]);
                GLFW.glfwWindowHint(139267, OpenGLHelper.versionPairs[i + 1]);
                this.window = GLFW.glfwCreateWindow(width, height, "Better than Adventure! " + Global.VERSION, 0L, 0L);
                if (this.window != 0L) break;
                if (i != OpenGLHelper.versionPairs.length - 2) continue;
                MemoryStack stack = MemoryStack.stackPush();
                try {
                    PointerBuffer b = stack.callocPointer(1);
                    GLFW.glfwGetError(b);
                    throw new NullPointerException("Failed to create window: " + b.getStringASCII());
                }
                catch (Throwable b) {
                    if (stack != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable throwable) {
                            b.addSuppressed(throwable);
                        }
                    }
                    throw b;
                }
            }
            GLFW.glfwMakeContextCurrent(this.window);
            GLCapabilities capabilities = GL.createCapabilities(true);
            OpenGLHelper.testCapabilities(capabilities);
            if (capabilities.OpenGL43 && debug) {
                GL11.glEnable(37600);
                this.glDebugMessageCallback = new OpenGLLoggerCallback();
                GL43.glDebugMessageCallback(this.glDebugMessageCallback, 0L);
                LOGGER.info("GL4.3 supported, enabling GL Error logging");
            } else {
                LOGGER.info("GL4.3 not supported, cannot enable GL Error logging");
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer w = stack.callocInt(1);
                IntBuffer h = stack.callocInt(1);
                GLFW.glfwGetWindowSize(this.window, w, h);
                this.widthScreenCoords = w.get(0);
                this.heightScreenCoords = h.get(0);
                GLFW.glfwGetFramebufferSize(this.window, w, h);
                this.widthPixels = w.get(0);
                this.heightPixels = h.get(0);
            }
            MonitorInfo monitor = new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.window, (monitor.widthScreenCoords - this.widthScreenCoords) / 2, (monitor.heightScreenCoords - this.heightScreenCoords) / 2);
            GLFW.glfwSetWindowSizeCallback(this.window, (window, ww, hh) -> {
                this.widthScreenCoords = Math.max(1, ww);
                this.heightScreenCoords = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetFramebufferSizeCallback(this.window, (window, ww, hh) -> {
                this.widthPixels = Math.max(1, ww);
                this.heightPixels = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetWindowFocusCallback(this.window, (window, focused) -> {
                this.hasFocus = focused;
                if (Mouse.isGrabbed() && !focused) {
                    Mouse.setGrabbed(false);
                }
            });
            if (Minecraft.getOs() != EnumOS.macos) {
                int[] resolutions = new int[]{16, 32, 64, 128, 256};
                GLFWImage.Buffer gb = GLFWImage.create(resolutions.length);
                for (int res : resolutions) {
                    ByteBuffer icon = GameWindowGLFW.getImageBuffer("/icon/" + res + ".png");
                    if (icon == null) {
                        LOGGER.error("Icon at resolution '{}' is null! Skipping icons!", (Object)res);
                        gb.close();
                        break block22;
                    }
                    GLFWImage iconGI = GLFWImage.create().set(res, res, icon);
                    gb.put(iconGI);
                    this.stbiIconImages.add(icon);
                }
                GLFW.glfwSetWindowIcon(this.window, (GLFWImage.Buffer)gb.flip());
            }
        }
        GLFW.glfwShowWindow(this.window);
        Display.setWindow(this);
        try {
            Method createKeyboard = Keyboard.class.getDeclaredMethod("create", InputImplementation.class);
            createKeyboard.setAccessible(true);
            Method createMouse = Mouse.class.getDeclaredMethod("create", InputImplementation.class);
            createMouse.setAccessible(true);
            GLFWKeyboardImplementation keyboardImplementation = new GLFWKeyboardImplementation();
            GLFWMouseImplementation mouseImplementation = new GLFWMouseImplementation();
            CombinedInputImplementation inputImplementation = new CombinedInputImplementation(keyboardImplementation, mouseImplementation);
            createKeyboard.invoke(null, inputImplementation);
            createMouse.invoke(null, inputImplementation);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setVsync((Boolean)this.mc.gameSettings.enableVsync.value);
    }

    @Override
    public void setCursorShape(CursorShape shape) {
        int shapeVal;
        switch (shape) {
            case ARROW: {
                shapeVal = 221185;
                break;
            }
            case I_BEAM: {
                shapeVal = 221186;
                break;
            }
            case CROSSHAIR: {
                shapeVal = 221187;
                break;
            }
            case HAND: {
                shapeVal = 221188;
                break;
            }
            case HORIZONTAL_RESIZE: {
                shapeVal = 221189;
                break;
            }
            case VERTICAL_RESIZE: {
                shapeVal = 221190;
                break;
            }
            default: {
                return;
            }
        }
        if (this.cursors.containsKey((Object)shape)) {
            GLFW.glfwSetCursor(this.window, this.cursors.get((Object)shape));
        } else {
            long cursor = GLFW.glfwCreateStandardCursor(shapeVal);
            this.cursors.put(shape, cursor);
            GLFW.glfwSetCursor(this.window, cursor);
        }
        this.currentCursor = shape;
    }

    @Override
    public void setWindowSize(int width, int height) {
        GLFW.glfwSetWindowSize(this.window, width, height);
    }

    @Override
    public CursorShape getCursorShape() {
        return this.currentCursor;
    }

    @Override
    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.value = (Boolean)this.mc.gameSettings.fullscreen.value == false;
        this.updateWindowState();
    }

    @Override
    public void updateWindowState() {
        if (!this.isFullscreen) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer x = stack.callocInt(1);
                IntBuffer y = stack.callocInt(1);
                GLFW.glfwGetWindowPos(this.window, x, y);
                IntBuffer w = stack.callocInt(1);
                IntBuffer h = stack.callocInt(1);
                GLFW.glfwGetWindowSize(this.window, w, h);
                this.windowPosX = x.get(0);
                this.windowPosY = y.get(0);
                this.windowWidth = w.get(0);
                this.windowHeight = h.get(0);
            }
        }
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        boolean borderless = (Boolean)this.mc.gameSettings.borderlessFullscreen.value;
        GLFW.glfwHideWindow(this.window);
        if (fullscreen && !borderless) {
            LOGGER.info("Setting window to FULLSCREEN...");
            int x = this.windowPosX + this.windowWidth / 2;
            int y = this.windowPosY + this.windowHeight / 2;
            monitor = this.getMonitorAt(x, y);
            GLFW.glfwSetWindowMonitor(this.window, monitor.handle, monitor.posX, monitor.posY, monitor.widthScreenCoords, monitor.heightScreenCoords, monitor.refreshRate);
            this.isFullscreen = true;
        } else {
            GLFW.glfwSetWindowMonitor(this.window, 0L, this.windowPosX, this.windowPosY, this.windowWidth, this.windowHeight, 0);
            if (fullscreen && borderless) {
                LOGGER.info("Setting window to BORDERLESS FULLSCREEN...");
                int x = this.windowPosX + this.windowWidth / 2;
                int y = this.windowPosY + this.windowHeight / 2;
                monitor = this.getMonitorAt(x, y);
                GLFW.glfwSetWindowAttrib(this.window, 131077, 0);
                GLFW.glfwSetWindowPos(this.window, monitor.posX, monitor.posY);
                GLFW.glfwSetWindowSize(this.window, monitor.widthScreenCoords, monitor.heightScreenCoords);
                this.isFullscreen = true;
            } else {
                LOGGER.info("Setting window to WINDOWED...");
                GLFW.glfwSetWindowAttrib(this.window, 131077, 1);
                this.isFullscreen = false;
            }
        }
        GLFW.glfwShowWindow(this.window);
    }

    public MonitorInfo getMonitorAt(int x, int y) {
        PointerBuffer monitorPointers = GLFW.glfwGetMonitors();
        if (monitorPointers != null) {
            for (int i = monitorPointers.position(); i < monitorPointers.limit(); ++i) {
                long monitor = monitorPointers.get(i);
                MonitorInfo info = new MonitorInfo(monitor);
                if (x < info.posX || y < info.posY || x >= info.posX + info.widthScreenCoords || y >= info.posY + info.heightScreenCoords) continue;
                return info;
            }
        }
        return new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        JFrame frame = new JFrame();
        PanelCrashReport panel = new PanelCrashReport(this.mc, unexpectedThrowable, cause);
        panel.setPreferredSize(new Dimension(1280, 720));
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public int getFrequency() {
        GLFWVidMode vidMode;
        long monitor = GLFW.glfwGetWindowMonitor(this.window);
        if (monitor != 0L && (vidMode = GLFW.glfwGetVideoMode(monitor)) != null) {
            return vidMode.refreshRate();
        }
        int x = this.windowPosX + this.windowWidth / 2;
        int y = this.windowPosY + this.windowHeight / 2;
        MonitorInfo info = this.getMonitorAt(x, y);
        return info.refreshRate;
    }

    @Override
    public void update() {
        GLFW.glfwPollEvents();
        if (this.isFocused()) {
            Keyboard.poll();
        }
        Mouse.poll();
        GLFW.glfwSwapBuffers(this.window);
    }

    @Override
    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose(this.window);
    }

    @Override
    public int getWidthScreenCoords() {
        return this.widthScreenCoords;
    }

    @Override
    public int getHeightScreenCoords() {
        return this.heightScreenCoords;
    }

    @Override
    public int getWidthPixels() {
        return this.widthPixels;
    }

    @Override
    public int getHeightPixels() {
        return this.heightPixels;
    }

    @Override
    public boolean isFocused() {
        return this.hasFocus;
    }

    @Override
    public boolean wasResized() {
        if (this.wasResized) {
            this.wasResized = false;
            return true;
        }
        return false;
    }

    @Override
    public void setVsync(boolean vsync) {
        if (vsync) {
            GLFW.glfwSwapInterval(1);
        } else {
            GLFW.glfwSwapInterval(0);
        }
    }

    @Override
    public long getHandle() {
        return this.window;
    }

    @Override
    public void free() {
        Callbacks.glfwFreeCallbacks(this.window);
        if (this.glfwErrorCallback != null) {
            this.glfwErrorCallback.free();
        }
        if (this.glDebugMessageCallback != null) {
            this.glDebugMessageCallback.free();
        }
        this.stbiIconImages.forEach(STBImage::stbi_image_free);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ByteBuffer getImageBuffer(String resource) {
        try (InputStream stream = GameWindowGLFW.class.getResourceAsStream(resource);){
            ByteBuffer returnBuf;
            if (stream == null) {
                LOGGER.error("No icon could be found at '{}'!", (Object)resource);
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer x = stack.mallocInt(1);
                IntBuffer y = stack.mallocInt(1);
                IntBuffer comp = stack.mallocInt(1);
                ByteBuffer buffer = GameWindowGLFW.streamToBuffer(stream);
                returnBuf = Objects.requireNonNull(STBImage.stbi_load_from_memory(buffer, x, y, comp, 4), STBImage::stbi_failure_reason);
                MemoryUtil.memFree(buffer);
            }
            ByteBuffer byteBuffer = returnBuf;
            return byteBuffer;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't open icon image...", e);
            return null;
        }
    }

    public static ByteBuffer streamToBuffer(@NotNull InputStream inputStream) throws IOException {
        int byteNum = inputStream.available();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(byteNum);
        int read = inputStream.read();
        while (read != -1) {
            if (byteBuffer.remaining() == 0) {
                ByteBuffer oldBuf = byteBuffer;
                byteBuffer = MemoryUtil.memAlloc((int)((float)oldBuf.capacity() * 1.25f));
                byteBuffer.put(oldBuf);
                MemoryUtil.memFree(oldBuf);
            }
            byteBuffer.put((byte)read);
            read = inputStream.read();
        }
        return byteBuffer.flip();
    }

    public static class MonitorInfo {
        public final long handle;
        public final int posX;
        public final int posY;
        public final int widthScreenCoords;
        public final int heightScreenCoords;
        public final int refreshRate;

        public MonitorInfo(long monitor) {
            this.handle = monitor;
            GLFWVidMode vidmode = Objects.requireNonNull(GLFW.glfwGetVideoMode(monitor), "No Video for monitor");
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer x = stack.callocInt(1);
                IntBuffer y = stack.callocInt(1);
                GLFW.glfwGetMonitorPos(monitor, x, y);
                this.posX = x.get(0);
                this.posY = y.get(0);
            }
            this.widthScreenCoords = vidmode.width();
            this.heightScreenCoords = vidmode.height();
            this.refreshRate = vidmode.refreshRate();
        }
    }
}

