/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.material;

import net.minecraft.core.block.material.MaterialColor;
import org.jetbrains.annotations.NotNull;

public class Material {
    public static final int PISTON_PUSHABLE = 0;
    public static final int PISTON_DESTROY_ON_PUSH = 1;
    public static final int PISTON_CANT_PUSH = 2;
    public static final int LIGHTNING_NEUTRAL = 0;
    public static final int LIGHTNING_STRONG_CONDUCTOR = 20;
    public static final int LIGHTNING_LIGHT_CONDUCTOR = 5;
    public static final int LIGHTNING_LIGHT_INSULATOR = -5;
    public static final int LIGHTNING_STRONG_INSULATOR = -20;
    private boolean flammable;
    private boolean replaceable;
    private boolean notSolidBlocking;
    @NotNull
    public final MaterialColor color;
    private boolean alwaysDestroyable = true;
    private boolean isStone;
    private boolean isMetal;
    private int pushReaction = 0;
    private int lightningConductivity = 0;

    public Material(@NotNull MaterialColor color) {
        this.color = color;
    }

    public boolean isLiquid() {
        return false;
    }

    public boolean isSolid() {
        return true;
    }

    public boolean blocksLight() {
        return true;
    }

    public boolean blocksMotion() {
        return true;
    }

    @NotNull
    public Material setAsStone() {
        this.isStone = true;
        return this;
    }

    public boolean isStone() {
        return this.isStone;
    }

    @NotNull
    public Material setAsMetal() {
        this.isMetal = true;
        return this;
    }

    public boolean isMetal() {
        return this.isMetal;
    }

    @NotNull
    public Material notSolidBlocking() {
        this.notSolidBlocking = true;
        return this;
    }

    @NotNull
    public Material notAlwaysDestroyable() {
        this.alwaysDestroyable = false;
        return this;
    }

    @NotNull
    public Material flammable() {
        this.flammable = true;
        return this;
    }

    public boolean isFlammable() {
        return this.flammable;
    }

    @NotNull
    public Material replaceable() {
        this.replaceable = true;
        return this;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public boolean isSolidBlocking() {
        if (this.notSolidBlocking) {
            return false;
        }
        return this.blocksMotion();
    }

    public boolean isAlwaysDestroyable() {
        return this.alwaysDestroyable;
    }

    public int getPushReaction() {
        return this.pushReaction;
    }

    @NotNull
    public Material destroyOnPush() {
        this.pushReaction = 1;
        return this;
    }

    @NotNull
    public Material notPushable() {
        this.pushReaction = 2;
        return this;
    }

    public int getConductivity() {
        return this.lightningConductivity;
    }

    @NotNull
    public Material setConductivity(int conductivity) {
        this.lightningConductivity = conductivity;
        return this;
    }
}

