/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWandSpawner
extends Item
implements IDispensable {
    public ItemWandSpawner(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        double reachDistance;
        HitResult rayTraceResult;
        if (player.gamemode != Gamemode.creative) {
            player.sendTranslatedChatMessage("wand.wrongmode");
            return selfStack;
        }
        if (!player.isSneaking() && (rayTraceResult = player.rayCast(reachDistance = (double)player.getGamemode().getBlockReachDistance(), 1.0f, false, false, false)) != null) {
            if (!world.isClientSide) {
                this.spawnEntity(selfStack, world, rayTraceResult.location.x(), rayTraceResult.location.y(), rayTraceResult.location.z());
            }
            return selfStack;
        }
        player.displayWandMobPickerScreen(selfStack);
        return selfStack;
    }

    @NotNull
    private String getEntityId(@NotNull ItemStack itemStack) {
        String id = itemStack.getData().getString("monster");
        if (id == null || id.isEmpty()) {
            id = "Pig";
        }
        return id;
    }

    public void spawnEntity(@NotNull ItemStack itemStack, @NotNull World world, double x, double y, double z) {
        Entity entity = EntityDispatcher.getInstance().createEntityInWorld(this.getEntityId(itemStack), world);
        if (entity != null) {
            entity.setPos(x, y, z);
            entity.spawnInit();
            String customName = itemStack.getCustomName();
            if (customName != null && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (itemStack.hasCustomColor()) {
                    mob.chatColor = itemStack.getCustomColor();
                }
                mob.setNickname(customName);
            }
            world.entityJoinedWorld(entity);
        }
    }

    @Override
    public void onDispensed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Random random, @NotNull Direction direction, double x, double y, double z) {
        this.spawnEntity(selfStack, world, x + (double)direction.getOffsetX() * 0.5, y + (double)direction.getOffsetY() * 0.5, z + (double)direction.getOffsetZ() * 0.5);
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        this.spawnEntity(selfStack, world, (double)blockPos.x() + offX + (double)direction.getOffsetX() * 0.5, (double)blockPos.y() + offY + (double)direction.getOffsetY() * 0.5, (double)blockPos.z() + offZ + (double)direction.getOffsetZ() * 0.5);
    }
}

