/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.Random;
import net.minecraft.core.block.BlockLogicSand;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeatureColdFire;
import net.minecraft.core.world.generate.feature.WorldFeatureCrystalChunk;
import net.minecraft.core.world.generate.feature.WorldFeatureDeadBush;
import net.minecraft.core.world.generate.feature.WorldFeatureFire;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneA;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneB;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureLiquid;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherLava;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePillar;
import net.minecraft.core.world.generate.feature.WorldFeaturePumice;
import net.minecraft.core.world.noise.PerlinNoise;
import org.jetbrains.annotations.NotNull;

public class ChunkDecoratorNether
implements ChunkDecorator {
    @NotNull
    private final World world;
    @NotNull
    private final PerlinNoise crystalDensityNoise;

    public ChunkDecoratorNether(@NotNull World world) {
        this.world = world;
        this.crystalDensityNoise = new PerlinNoise(world.getRandomSeed(), 6, 74);
    }

    @Override
    public void decorate(@NotNull Chunk chunk) {
        int zf;
        int yf;
        int xf;
        int i;
        int max;
        int zf2;
        int yf2;
        int xf2;
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        Random rand = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        BlockLogicSand.fallInstantly = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        Biome biome = this.world.getBlockBiome(x + 16, minY, z + 16);
        if (biome == Biomes.NETHER_CRYSTAL_FOREST) {
            int zf3;
            int yf3;
            int xf3;
            int i2;
            double noiseScale = 0.5;
            int density = (int)((this.crystalDensityNoise.get((double)x * noiseScale, (double)z * noiseScale) - 6.0 + 36.0) / 6.0);
            for (i2 = 0; i2 < density - 5; ++i2) {
                xf3 = x + rand.nextInt(16) + 8;
                yf3 = this.world.getWorldType().getOceanY() + rand.nextInt(5);
                zf3 = z + rand.nextInt(16) + 8;
                boolean isCeiling = rand.nextInt(5) == 0;
                new WorldFeatureCrystalChunk(isCeiling).place(this.world, rand, xf3, yf3, zf3);
            }
            for (i2 = 0; i2 < density - 5; ++i2) {
                xf3 = x + rand.nextInt(16) + 8;
                yf3 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf3 = z + rand.nextInt(16) + 8;
                new WorldFeatureCrystalChunk(false, 15, 30, true).place(this.world, rand, xf3, yf3, zf3);
            }
            for (i2 = 0; i2 < 40; ++i2) {
                xf3 = x + rand.nextInt(16) + 8;
                yf3 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf3 = z + rand.nextInt(16) + 8;
                new WorldFeatureDeadBush(Blocks.CRYSTAL_STALK.id()).place(this.world, rand, xf3, yf3, zf3);
            }
            for (int l18 = 0; l18 < 50; ++l18) {
                int l21 = x + rand.nextInt(16) + 8;
                int k23 = minY + rand.nextInt(rand.nextInt(rangeY - rangeY / 16) + rangeY / 16);
                int l24 = z + rand.nextInt(16) + 8;
                new WorldFeatureLiquid(Blocks.FLUID_WATER_FLOWING.id()).place(this.world, rand, l21, k23, l24);
            }
        }
        if (biome == Biomes.NETHER_ASH_PLAINS && rand.nextInt(2) == 0) {
            int xf4 = x + rand.nextInt(16) + 8;
            int yf4 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            int zf4 = z + rand.nextInt(16) + 8;
            new WorldFeaturePillar(Blocks.SLATE.id(), false).place(this.world, rand, xf4, yf4, zf4);
        }
        if (biome != Biomes.NETHER_ASH_PLAINS && biome != Biomes.NETHER_BONEYARD) {
            for (int i3 = 0; i3 < 8; ++i3) {
                xf2 = x + rand.nextInt(16) + 8;
                yf2 = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
                zf2 = z + rand.nextInt(16) + 8;
                new WorldFeatureNetherLava(Blocks.FLUID_LAVA_FLOWING.id()).place(this.world, rand, xf2, yf2, zf2);
            }
        }
        for (int i4 = 0; i4 < 10; ++i4) {
            xf2 = x + rand.nextInt(16);
            yf2 = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
            zf2 = z + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_NETHERCOAL_NETHERRACK.id(), 12).place(this.world, rand, xf2, yf2, zf2);
        }
        if (biome != Biomes.NETHER_ASH_PLAINS && biome != Biomes.NETHER_BONEYARD) {
            max = rand.nextInt(rand.nextInt(10) + 1);
            for (i = 0; i < max; ++i) {
                xf = x + rand.nextInt(16) + 8;
                yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf = z + rand.nextInt(16) + 8;
                new WorldFeatureFire().place(this.world, rand, xf, yf, zf);
            }
        }
        if (biome == Biomes.NETHER_BONEYARD) {
            max = rand.nextInt(20) + 5;
            for (i = 0; i < max; ++i) {
                xf = x + rand.nextInt(16) + 8;
                yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf = z + rand.nextInt(16) + 8;
                new WorldFeatureColdFire().place(this.world, rand, xf, yf, zf);
            }
        }
        max = rand.nextInt(rand.nextInt(10) + 1);
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneA().place(this.world, rand, xf, yf, zf);
        }
        for (i = 0; i < 10; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneB().place(this.world, rand, xf, yf, zf);
        }
        if (biome != Biomes.NETHER_ASH_PLAINS && biome != Biomes.NETHER_BONEYARD) {
            if (rand.nextInt(8) == 0) {
                xf2 = x + rand.nextInt(16) + 8;
                yf2 = rangeY / 2 + rand.nextInt(rangeY - 16) + 8;
                zf2 = z + rand.nextInt(16) + 8;
                new WorldFeatureLake(Blocks.FLUID_LAVA_STILL.id()).place(this.world, rand, xf2, yf2, zf2);
            }
            for (i = 0; i < 80; ++i) {
                xf = x + rand.nextInt(16);
                yf = rangeY / 2 + rand.nextInt(rangeY);
                zf = z + rand.nextInt(16);
                new WorldFeaturePumice(32).place(this.world, rand, xf, yf, zf);
            }
        }
        int oceanY = this.world.getWorldType().getOceanY();
        int midY = oceanY + (this.world.getWorldType().getMaxY() - oceanY) / 2;
        for (int dx = x + 8; dx < x + 8 + 16; ++dx) {
            for (int dz = z + 8; dz < z + 8 + 16; ++dz) {
                Biome localBiome;
                int dy = midY;
                while (this.world.getBlockId(dx, dy, dz) == 0) {
                    --dy;
                }
                if ((localBiome = this.world.getBlockBiome(dx, ++dy, dz)) != Biomes.NETHER_ASH_PLAINS && localBiome != Biomes.NETHER_BONEYARD || dy <= 0 || dy >= this.world.getHeightBlocks() || !this.world.isAirBlock(dx, dy, dz) || !this.world.getBlockMaterial(dx, dy - 1, dz).blocksMotion() || this.world.getBlockId(dx, dy - 1, dz) == Blocks.OBSIDIAN.id()) continue;
                this.world.setBlockWithNotify(dx, dy, dz, Blocks.LAYER_ASH.id());
            }
        }
        BlockLogicSand.fallInstantly = false;
    }
}

