/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.FloatBuffer;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.shader.ShaderProvider;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class Shader {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final FloatBuffer mat4fBuf = BufferUtils.createFloatBuffer(16);
    protected int program;
    protected int vertexShader;
    protected int fragmentShader;
    public boolean supported = true;
    protected boolean enabled = false;
    @NotNull
    protected final Object2IntMap<String> uniformLocations = new Object2IntOpenHashMap<String>();
    @NotNull
    protected final Object2IntMap<String> uniformBlockLocations = new Object2IntOpenHashMap<String>();

    @NotNull
    public Shader compile(@NotNull ShaderProvider folder, @NotNull String name) {
        if (!this.supported) {
            return this;
        }
        OpenGLHelper.checkError("pre compile shader " + name);
        this.delete();
        String fragmentSource = folder.getShaderSource(name + ".fsh");
        String vertexSource = folder.getShaderSource(name + ".vsh");
        if (fragmentSource == null) {
            return this;
        }
        if (vertexSource == null) {
            return this;
        }
        this.vertexShader = GL20.glCreateShader(35633);
        this.fragmentShader = GL20.glCreateShader(35632);
        GL20.glShaderSource(this.vertexShader, (CharSequence)vertexSource);
        GL20.glShaderSource(this.fragmentShader, (CharSequence)fragmentSource);
        GL20.glCompileShader(this.vertexShader);
        GL20.glCompileShader(this.fragmentShader);
        int fragmentShaderCompileStatus = GL20.glGetShaderi(this.fragmentShader, 35713);
        int vertexShaderCompileStatus = GL20.glGetShaderi(this.vertexShader, 35713);
        if (fragmentShaderCompileStatus != 1 || vertexShaderCompileStatus != 1) {
            LOGGER.error("Shader {} compile error", (Object)name);
            if (vertexShaderCompileStatus != 1) {
                LOGGER.error("Vertex Shader Info Log: {}", (Object)GL20.glGetShaderInfoLog(this.vertexShader, GL20.glGetShaderi(this.vertexShader, 35716)));
            }
            if (fragmentShaderCompileStatus != 1) {
                LOGGER.error("Fragment Shader Info Log: {}", (Object)GL20.glGetShaderInfoLog(this.fragmentShader, GL20.glGetShaderi(this.fragmentShader, 35716)));
            }
            this.delete();
            return this;
        }
        this.program = GL20.glCreateProgram();
        GL20.glAttachShader(this.program, this.fragmentShader);
        GL20.glAttachShader(this.program, this.vertexShader);
        GL20.glLinkProgram(this.program);
        int programLinkStatus = GL20.glGetProgrami(this.program, 35714);
        if (programLinkStatus != 1) {
            LOGGER.error("Program Link Error: ");
            LOGGER.error(GL20.glGetProgramInfoLog(this.program, GL20.glGetProgrami(this.program, 35716)));
            this.delete();
            return this;
        }
        GL20.glDeleteShader(this.vertexShader);
        GL20.glDeleteShader(this.fragmentShader);
        this.vertexShader = 0;
        this.fragmentShader = 0;
        this.enabled = true;
        OpenGLHelper.checkError("compile shader " + name);
        return this;
    }

    public int getUniform(@NotNull String uniform) {
        int location = this.uniformLocations.getOrDefault((Object)uniform, -2);
        if (location == -2) {
            location = GL20.glGetUniformLocation(this.program, uniform);
            this.uniformLocations.put(uniform, location);
        }
        return location;
    }

    public int getUniformBlock(@NotNull String uniform) {
        int location = this.uniformBlockLocations.getOrDefault((Object)uniform, -2);
        if (location == -2) {
            location = GL41.glGetUniformBlockIndex(this.program, uniform);
            this.uniformBlockLocations.put(uniform, location);
        }
        return location;
    }

    public void delete() {
        this.enabled = false;
        this.uniformLocations.clear();
        OpenGLHelper.checkError("pre delete shader");
        if (this.program != 0) {
            GL20.glDeleteProgram(this.program);
            this.program = 0;
        }
        if (this.fragmentShader != 0) {
            GL20.glDeleteShader(this.fragmentShader);
            this.fragmentShader = 0;
        }
        if (this.vertexShader != 0) {
            GL20.glDeleteShader(this.vertexShader);
            this.vertexShader = 0;
        }
        OpenGLHelper.checkError("delete shader");
    }

    public int id() {
        return this.program;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void bind() {
        GL20.glUseProgram(this.program);
    }

    public void unbind() {
        GL20.glUseProgram(0);
    }

    public static int getCompileStatus(int shader) {
        return GL20.glGetShaderi(shader, 35713);
    }

    public void uniformFloat(@NotNull String name, float value) {
        int loc = this.getUniform(name);
        if (loc >= 0) {
            GL20.glUniform1f(loc, value);
        }
    }

    public void uniformFloat(@NotNull String name, boolean value) {
        this.uniformFloat(name, value ? 1.0f : 0.0f);
    }

    public void uniformInt(@NotNull String name, int value) {
        int loc = this.getUniform(name);
        if (loc >= 0) {
            GL20.glUniform1i(loc, value);
        }
    }

    public void uniformBool(@NotNull String name, boolean value) {
        this.uniformInt(name, value ? 1 : 0);
    }

    public void uniformMat4f(@NotNull String name, @NotNull Matrix4fc matrix4f) {
        int loc = this.getUniform(name);
        if (loc >= 0) {
            GL41.glUniformMatrix4fv(loc, false, matrix4f.get(mat4fBuf));
        }
    }

    public void uniformVec2f(@NotNull String name, float x, float y) {
        int loc = this.getUniform(name);
        if (loc >= 0) {
            GL41.glUniform2f(loc, x, y);
        }
    }

    public void uniformVec2f(@NotNull String name, @NotNull Vector2fc vector2f) {
        this.uniformVec2f(name, vector2f.x(), vector2f.y());
    }

    public void uniformVec3f(@NotNull String name, float x, float y, float z) {
        int loc = this.getUniform(name);
        if (loc >= 0) {
            GL41.glUniform3f(loc, x, y, z);
        }
    }

    public void uniformVec3f(@NotNull String name, @NotNull Vector3fc vector3f) {
        this.uniformVec3f(name, vector3f.x(), vector3f.y(), vector3f.z());
    }

    public void uniformVec4f(@NotNull String name, float x, float y, float z, float w) {
        int loc = this.getUniform(name);
        if (loc >= 0) {
            GL41.glUniform4f(loc, x, y, z, w);
        }
    }

    public void uniformVec4f(@NotNull String name, @NotNull Vector4fc vector4f) {
        this.uniformVec4f(name, vector4f.x(), vector4f.y(), vector4f.z(), vector4f.w());
    }

    public void uniformBlockBinding(@NotNull String name, int index) {
        int loc = this.getUniformBlock(name);
        if (loc >= 0) {
            GL41.glUniformBlockBinding(this.program, loc, index);
        }
    }
}

