/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicDoorPainted
extends BlockLogicDoor
implements IPainted {
    public BlockLogicDoorPainted(@NotNull Block<?> block, @NotNull Material material, boolean isTop) {
        super(block, material, isTop, false, null);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.DOOR_OAK_PAINTED, 1, 15 - (data >> 4 & 0xF))};
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta >> 4 & 0xF);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta << 4;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePosc tilePos) {
        int data = world.getBlockData(tilePos);
        world.setBlockIdDataNotify(tilePos, this.isTop ? Blocks.DOOR_PLANKS_OAK_TOP.id() : Blocks.DOOR_PLANKS_OAK_BOTTOM.id(), data & 0xF);
        if (this.isTop) {
            world.setBlockIdDataNotify(tilePos.down(new TilePos()), Blocks.DOOR_PLANKS_OAK_BOTTOM.id(), data & 0xF);
        } else {
            world.setBlockIdDataNotify(tilePos.up(new TilePos()), Blocks.DOOR_PLANKS_OAK_TOP.id(), data & 0xF);
        }
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        int data = world.getBlockData(tilePos);
        world.setBlockDataNotify(tilePos, data & 0xF | this.toMetadata(color));
        if (this.isTop) {
            world.setBlockDataNotify(tilePos.down(new TilePos()), data & 0xF | this.toMetadata(color));
        } else {
            world.setBlockDataNotify(tilePos.up(new TilePos()), data & 0xF | this.toMetadata(color));
        }
    }
}

