/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FloatTag
extends Tag<Float> {
    public FloatTag() {
        this(0.0f);
    }

    public FloatTag(float value) {
        super(Float.valueOf(value));
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeFloat(((Float)this.getValue()).floatValue());
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        this.setValue(Float.valueOf(dis.readFloat()));
    }

    @Override
    public byte getId() {
        return Tag.TagID.TAG_FLOAT.getId();
    }

    @Override
    public void fromJson(@NotNull JsonElement json) throws JsonParseException {
        if (!json.isJsonPrimitive()) {
            throw new JsonParseException("Json element '" + String.valueOf(json) + "' is not a valid floatTag!");
        }
        this.setValue(Float.valueOf(json.getAsFloat()));
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        return new JsonPrimitive((Number)this.getValue());
    }

    public String toString() {
        return "\"" + this.getTagName() + "\": " + String.valueOf(this.getValue());
    }
}

