/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.drawing.IDrawableSurface;

public class DrawableSurfaceElement
extends Gui
implements IDrawableSurface<Byte> {
    private final int canvasWidth;
    private final int canvasHeight;
    private final int canvasScale;
    private final byte[] surfaceData;
    public int[] colors = new int[0];

    public DrawableSurfaceElement(int width, int height, int scale) {
        this(width, height, scale, new byte[width * height]);
    }

    public DrawableSurfaceElement(int width, int height, int scale, byte[] surfaceData) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.canvasScale = scale;
        this.surfaceData = surfaceData;
    }

    public void render(int x, int y) {
        for (int dx = 0; dx < this.canvasWidth; ++dx) {
            for (int dy = 0; dy < this.canvasHeight; ++dy) {
                this.drawRectNoBlend(x + dx * this.canvasScale, y + dy * this.canvasScale, x + dx * this.canvasScale + this.canvasScale, y + dy * this.canvasScale + this.canvasScale, this.getColor(this.getPixelValue(dx, dy)));
            }
        }
    }

    private int getColor(byte val) {
        if (val < 0 || val >= this.colors.length) {
            return 0;
        }
        return this.colors[val];
    }

    public void clear() {
        for (int dx = 0; dx < this.canvasWidth; ++dx) {
            for (int dy = 0; dy < this.canvasHeight; ++dy) {
                this.setPixelValue(dx, dy, (byte)0);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.canvasWidth;
    }

    @Override
    public int getHeight() {
        return this.canvasHeight;
    }

    @Override
    public Byte getPixelValue(int x, int y) {
        if (x < 0 || x >= this.canvasWidth) {
            return (byte)0;
        }
        if (y < 0 || y >= this.canvasHeight) {
            return (byte)0;
        }
        return this.surfaceData[x + this.canvasWidth * y];
    }

    @Override
    public boolean setPixelValue(int x, int y, Byte value) {
        if (x < 0 || x >= this.canvasWidth) {
            return false;
        }
        if (y < 0 || y >= this.canvasHeight) {
            return false;
        }
        this.surfaceData[x + this.canvasWidth * y] = value;
        return true;
    }
}

