/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerTextFieldElement;
import net.minecraft.client.render.font.FontRenderer;

public abstract class TextCycleElement<T>
extends ListenerButtonElement {
    private T currentElement;
    private final T defaultElement;
    public final ListenerButtonElement prevButton;
    public final ListenerButtonElement nextButton;
    public final ListenerTextFieldElement textField;

    public TextCycleElement(Screen parent, FontRenderer sr, int xPosition, int yPosition, int width, int height, T initialElement) {
        super(-1, xPosition, yPosition, width, height, "");
        this.textField = new ListenerTextFieldElement(parent, sr, 0, yPosition, width - height * 2 - 2, height, this.getNameFromElement(initialElement), "");
        this.textField.setKeyListener(key -> {
            String text = this.textField.getText();
            this.setCurrentElement(this.getElementFromString(text));
            this.textField.setText(text);
            this.textField.editor.setCursor(999999);
            this.textField.setText(text);
        });
        this.prevButton = new ListenerButtonElement(-1, xPosition, yPosition, height, height, "<");
        this.prevButton.setActionListener(() -> this.setCurrentElement(this.cycleElement(this.getCurrentElement(), -1)));
        this.textField.xPosition = this.prevButton.xPosition + this.prevButton.width + 1;
        this.nextButton = new ListenerButtonElement(-1, this.textField.xPosition + this.textField.width + 1, yPosition, height, height, ">");
        this.nextButton.setActionListener(() -> this.setCurrentElement(this.cycleElement(this.getCurrentElement(), 1)));
        this.defaultElement = initialElement;
        this.currentElement = initialElement;
    }

    public void reset() {
        this.setCurrentElement(this.defaultElement);
    }

    public void setCurrentElement(T element) {
        boolean flag = this.currentElement != element;
        this.currentElement = element;
        if (flag) {
            this.onValueChanged();
        }
    }

    public abstract T cycleElement(T var1, int var2);

    public abstract T getElementFromString(String var1);

    public abstract String getNameFromElement(T var1);

    public T getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public void onKeyTyped(char c, int key) {
        this.textField.onKeyTyped(c, key);
        super.onKeyTyped(c, key);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        boolean flag = this.prevButton.mouseClicked(mc, mouseX, mouseY);
        flag |= this.textField.mouseClicked(mc, mouseX, mouseY);
        super.mouseClicked(mc, mouseX, mouseY);
        return flag |= this.nextButton.mouseClicked(mc, mouseX, mouseY);
    }

    @Override
    public void tick() {
        this.prevButton.tick();
        this.nextButton.tick();
        this.textField.tick();
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        this.prevButton.enabled = this.enabled;
        this.prevButton.drawButton(mc, mouseX, mouseY);
        this.nextButton.enabled = this.enabled;
        this.nextButton.drawButton(mc, mouseX, mouseY);
        this.textField.enabled = this.enabled;
        this.textField.drawButton(mc, mouseX, mouseY);
    }

    @Override
    public void onValueChanged() {
        super.onValueChanged();
        this.textField.setText(this.getNameFromElement(this.getCurrentElement()));
    }

    @Override
    public void setX(int x) {
        this.xPosition = x;
        this.prevButton.setX(x);
        this.nextButton.setX(x + this.getWidth() - this.nextButton.getWidth());
        this.textField.setX(x + this.nextButton.width + 1);
    }

    @Override
    public void setY(int y) {
        this.yPosition = y;
        this.prevButton.setY(y);
        this.nextButton.setY(y);
        this.textField.setY(y);
    }

    @Override
    public boolean isHovered(int mouseX, int mouseY) {
        return this.textField.isFocused || super.isHovered(mouseX, mouseY);
    }
}

