/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.Util;
import org.jetbrains.annotations.NotNull;

public abstract class Option<E> {
    @NotNull
    public final GameSettings gameSettings;
    @NotNull
    public final String name;
    @NotNull
    public E value;
    @NotNull
    protected final E defaultValue;
    protected final List<OptionCallback<E>> callbacks = new ArrayList<OptionCallback<E>>();

    public Option(@NotNull GameSettings gameSettings, @NotNull String name, @NotNull E defaultValue) {
        this.gameSettings = gameSettings;
        this.name = name;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        GameSettings.options.add(this);
    }

    public void set(@NotNull E value) {
        this.value = value;
    }

    public void addCallback(@NotNull OptionCallback<E> callback) {
        this.callbacks.add(callback);
    }

    public abstract void parse(@NotNull String var1);

    public void onUpdate() {
        for (OptionCallback<E> callback : this.callbacks) {
            callback.onUpdate(this);
        }
        this.gameSettings.optionChanged(this);
    }

    @NotNull
    public String getDisplayString() {
        return this.gameSettings.getDisplayString(this);
    }

    @NotNull
    public String getDisplayStringValue() {
        return this.gameSettings.getDisplayString(this);
    }

    @NotNull
    public String getDisplayStringName() {
        return I18n.getInstance().translateKey("options." + this.name);
    }

    @NotNull
    public String getValueString() {
        return Util.emptyStringIfNull(this.value.toString());
    }

    @NotNull
    public E getDefaultValue() {
        return this.defaultValue;
    }

    public static interface OptionCallback<T> {
        public void onUpdate(Option<T> var1);
    }
}

