/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public final class LightingCache {
    private final Minecraft mc = Minecraft.getMinecraft();
    private static final int CACHE_RANGE = 1;
    private static final int CACHE_SIZE = 3;
    private final boolean[] brightnessCached = new boolean[27];
    private final float[] brightnessValue = new float[27];
    private final boolean[] opacityCached = new boolean[27];
    private final boolean[] opacityValue = new boolean[27];
    private final boolean[] lightmapCoordCached = new boolean[27];
    private final int[] lightmapCoordValue = new int[27];
    @NotNull
    private final TilePos offset = new TilePos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private Block<?> block;
    private WorldSource access;
    @NotNull
    private final TilePos queryPos = new TilePos();

    @Deprecated
    public void setupCache(@NotNull Block<?> block, @NotNull WorldSource source, int x, int y, int z) {
        this.setupCache(block, source, new TilePos(x, y, z));
    }

    public void setupCache(@NotNull Block<?> block, @NotNull WorldSource source, @NotNull TilePosc tilePos) {
        if (!tilePos.equals(this.offset) || this.block != block || this.access != source) {
            this.block = block;
            this.access = source;
            Arrays.fill(this.brightnessCached, false);
            Arrays.fill(this.opacityCached, false);
            Arrays.fill(this.lightmapCoordCached, false);
            this.offset.set(tilePos);
        }
    }

    private float calcBrightness(@NotNull TilePos tilePos) {
        int blockId = this.access.getBlockId(tilePos);
        Block<?> block = Blocks.getBlock(blockId);
        if (this.block.emission >= 15) {
            return 1.0f;
        }
        if (!this.mc.isAmbientOcclusionEnabled()) {
            return 1.0f;
        }
        if (block == null) {
            return 1.0f;
        }
        return 1.0f - block.getAmbientOcclusionStrength(this.access, tilePos);
    }

    public float getBrightness(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.brightnessCached[index]) {
            this.brightnessValue[index] = this.calcBrightness(this.offset.add(relX, relY, relZ, this.queryPos));
            this.brightnessCached[index] = true;
        }
        return this.brightnessValue[index];
    }

    public boolean getOpacity(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.opacityCached[index]) {
            this.opacityValue[index] = Blocks.solid[this.access.getBlockId(this.offset.add(relX, relY, relZ, this.queryPos))];
            this.opacityCached[index] = true;
        }
        return this.opacityValue[index];
    }

    public int getLightmapCoord(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.lightmapCoordCached[index]) {
            int lightEmission = this.block.emission;
            this.lightmapCoordValue[index] = this.access.getLightmapCoord(this.offset.add(relX, relY, relZ, this.queryPos), lightEmission);
            this.lightmapCoordCached[index] = true;
        }
        return this.lightmapCoordValue[index];
    }
}

