/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.render.DirtyChunkRendererSorter;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.particle.ParticleDispatcher;
import net.minecraft.client.render.particle.ParticleLambda;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemDiscMusic;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL41;

public class RenderGlobal
implements LevelListener {
    public static IconCoordinate[] breakingAnimation = new IconCoordinate[10];
    public static final int RENDER_CHUNK_SIZE = 16;
    public static final int MAX_VISIBLE_REBUILDS_PER_FRAME = 6;
    public static final int MAX_INVISIBLE_REBUILDS_PER_FRAME = 1;
    public List<TileEntity> renderableTileEntities = new ObjectArrayList<TileEntity>();
    private WorldClient world;
    private final TextureManager textureManager;
    private final List<@NotNull ChunkRenderer> dirtyChunks = new ObjectArrayList<ChunkRenderer>();
    private ChunkRenderer[] chunkRenderers;
    private int xChunks;
    private int yChunks;
    private int zChunks;
    private final Minecraft mc;
    private float lastCloudOffsetX = 0.0f;
    private float lastCloudOffsetZ = 0.0f;
    private float cloudOffsetX = 0.0f;
    private float cloudOffsetZ = 0.0f;
    private float cloudVelocityX;
    private float cloudVelocityZ;
    private int ticks;
    @NotNull
    private RenderBuffer starBuffer;
    @NotNull
    private final RenderBuffer skyBuffer;
    private int xMinChunk;
    private int yMinChunk;
    private int zMinChunk;
    private int xMaxChunk;
    private int yMaxChunk;
    private int zMaxChunk;
    private int renderDistance = 0;
    private int noEntityRenderFrames = 2;
    private int totalEntities;
    private int renderedEntities;
    private int culledEntities;
    private int totalChunks;
    private int offscreenChunks;
    private int occludedChunks;
    private int renderedChunks;
    private int emptyChunks;
    private int chunkFixOffs;
    double xOld = -9999.0;
    double yOld = -9999.0;
    double zOld = -9999.0;
    public float destroyProgress;
    int cullStep = 0;
    private double auroraBrightness = 0.0;
    private double targetAuroraBrightness = Double.NaN;
    private double rainbowBrightness = 0.0;
    private final DirtyChunkRendererSorter dirtyChunkRendererSorter = new DirtyChunkRendererSorter();
    private final @Nullable ChunkRenderer @NotNull [] toAdd = new ChunkRenderer[6];
    @NotNull
    private final @NotNull List<@NotNull ChunkRenderer> nearChunks = new ArrayList<ChunkRenderer>();

    public RenderGlobal(Minecraft mc, TextureManager textureManager) {
        this.mc = mc;
        this.textureManager = textureManager;
        this.starBuffer = this.renderStars();
        TessellatorShader t = GLRenderer.getTessellator();
        int s = 64;
        int d = 256 / s + 2;
        float yy = 16.0f;
        t.startDrawingQuads();
        for (int xx = -s * d; xx <= s * d; xx += s) {
            for (int zz = -s * d; zz <= s * d; zz += s) {
                t.addVertex(xx, yy, zz);
                t.addVertex(xx + s, yy, zz);
                t.addVertex(xx + s, yy, zz + s);
                t.addVertex(xx, yy, zz + s);
            }
        }
        this.skyBuffer = t.record(GL41.glGenVertexArrays(), GL41.glGenBuffers());
    }

    public void updateStars() {
        this.starBuffer.delete();
        this.starBuffer = this.renderStars();
    }

    @NotNull
    private RenderBuffer renderStars() {
        Random random = new Random(10842L);
        Random colorRandom = new Random(10842L);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (d4 >= 1.0 || d4 <= 0.01) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double x = (d *= d4) * 100.0;
            double y = (d1 *= d4) * 100.0;
            double z = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            double color = colorRandom.nextDouble();
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double yOff = d21 * d12 + d17 * d13;
                double d25 = d17 * d12 - d21 * d13;
                double xOff = d25 * d9 - d22 * d10;
                double zOff = d22 * d9 + d25 * d10;
                tessellator.addVertexWithUV(x + xOff, y + yOff, z + zOff, color, 0.0);
            }
        }
        return tessellator.record(GL41.glGenVertexArrays(), GL41.glGenBuffers());
    }

    public void setWorld(WorldClient world) {
        if (this.world != null) {
            this.world.removeListener(this);
        }
        this.xOld = -9999.0;
        this.yOld = -9999.0;
        this.zOld = -9999.0;
        this.world = world;
        this.auroraBrightness = 0.0;
        this.targetAuroraBrightness = Double.NaN;
        if (world != null) {
            world.addListener(this);
            this.allChanged();
        }
    }

    public void allChanged() {
        ScreenOptions.queueReload = false;
        this.updateStars();
        BlockModelLeaves.setGraphicsLevel((Integer)this.mc.gameSettings.fancyGraphics.value == 1);
        this.renderDistance = (Integer)this.mc.gameSettings.renderDistance.value;
        if (this.world == null) {
            return;
        }
        if (this.chunkRenderers != null) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                chunkRenderer.delete();
            }
        }
        int dist = this.renderDistance * 16 * 2;
        this.xOld = this.mc.activeCamera.getX();
        this.yOld = this.mc.activeCamera.getY();
        this.zOld = this.mc.activeCamera.getZ();
        this.xChunks = dist / 16 + 1;
        this.yChunks = this.world.getHeightBlocks() / 16;
        this.zChunks = dist / 16 + 1;
        this.chunkRenderers = new ChunkRenderer[this.xChunks * this.yChunks * this.zChunks];
        int id = 0;
        int count = 0;
        this.xMinChunk = 0;
        this.yMinChunk = 0;
        this.zMinChunk = 0;
        this.xMaxChunk = this.xChunks;
        this.yMaxChunk = this.yChunks;
        this.zMaxChunk = this.zChunks;
        for (ChunkRenderer cr : this.dirtyChunks) {
            cr.dirty = false;
        }
        this.dirtyChunks.clear();
        this.renderableTileEntities.clear();
        for (int x = 0; x < this.xChunks; ++x) {
            for (int y = 0; y < this.yChunks; ++y) {
                for (int z = 0; z < this.zChunks; ++z) {
                    int index = (z * this.yChunks + y) * this.xChunks + x;
                    this.chunkRenderers[index] = this.mc.terrainRenderer.createChunkRenderer(this.world, this.renderableTileEntities, x * 16, y * 16, z * 16, 16);
                    this.chunkRenderers[index].visible = true;
                    this.chunkRenderers[index].id = count++;
                    this.chunkRenderers[index].setDirty();
                    this.dirtyChunks.add(this.chunkRenderers[index]);
                    id += 3;
                }
            }
        }
        this.resortChunks(MathHelper.floor(this.mc.activeCamera.getX()), MathHelper.floor(this.mc.activeCamera.getY()), MathHelper.floor(this.mc.activeCamera.getZ()));
        this.noEntityRenderFrames = 2;
    }

    public void renderAurora(ICamera camera, float partialTick) {
        float celestialAngle = this.world.getCelestialAngle(partialTick);
        if (celestialAngle < 0.25f) {
            return;
        }
        double cameraX = camera.getX(partialTick);
        double cameraY = camera.getY(partialTick);
        double cameraZ = camera.getZ(partialTick);
        double cameraYaw = camera.getYRot(partialTick);
        double temperature = this.world.getBlockTemperature((int)cameraX, (int)cameraZ);
        float mult = 0.0f;
        if ((temperature <= (double)0.4f || this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) && this.world.isChunkLoaded((int)cameraX, (int)cameraZ)) {
            temperature /= (double)0.4f;
            temperature = -temperature + 1.0;
            mult = (float)((double)mult + temperature);
        }
        double altitude = this.world.getWorldType().getYPercentage((int)cameraY);
        if ((temperature <= (double)0.6f || this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) && altitude >= (double)0.8f) {
            if ((altitude -= (double)0.8f) > (double)0.1f) {
                altitude = 0.1f;
            }
            mult = (float)((double)mult + altitude);
        }
        if (mult < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        if (Double.isNaN(this.targetAuroraBrightness)) {
            this.auroraBrightness = mult;
        }
        this.targetAuroraBrightness = mult;
        double totalDelta = this.targetAuroraBrightness - this.auroraBrightness;
        double auroraBrightnessDelta = totalDelta / 100.0;
        this.auroraBrightness += auroraBrightnessDelta * (double)partialTick;
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setDepthFunc(CompareFunc.ALWAYS);
        double scale = 1.0;
        double auroraY = ((float)(this.world.getWorldType().getMinY() + this.world.getWorldType().getYRange()) + 64.0f) * 2.0f;
        double rotationX = Math.cos(cameraYaw * Math.PI / 180.0);
        double rotationZ = Math.sin(cameraYaw * Math.PI / 180.0);
        this.textureManager.bindTexture(this.textureManager.loadTexture("/assets/minecraft/textures/environment/aurora.png"));
        double time = (float)this.world.getWorldTime() + partialTick;
        AuroraProvider aurora = this.world.auroraProvider;
        double radius = 512.0;
        long worldTime = this.world.getWorldTime();
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        for (double x = -radius; x < radius; x += 16.0) {
            for (double z = -radius; z < radius; z += 16.0) {
                double posX = cameraX + x;
                double posZ = cameraZ + z;
                double distanceSq = x * x + z + z;
                double distanceSqPercentage = distanceSq / (radius * radius + radius * radius);
                distanceSqPercentage = 1.0 - distanceSqPercentage;
                double sample = aurora.getAuroraPresence(posX, posZ, worldTime, celestialAngle) * this.auroraBrightness;
                if (sample * (double)0.3f * distanceSqPercentage < (double)0.01f) continue;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        double xOff = i * 8;
                        double zOff = j * 8;
                        this.renderAuroraBeam(t, (x + xOff) * 1.0, auroraY * 1.0 - cameraY * 1.0 + aurora.getAuroraHeightOffset(posX + xOff, posZ + zOff, time), (z + zOff) * 1.0, rotationX, rotationZ, aurora.getAuroraRedOffset(posX + xOff, posZ + zOff, time), aurora.getAuroraGreenOffset(posX + xOff, posZ + zOff, time), aurora.getAuroraBlueOffset(posX + xOff, posZ + zOff, time), 1.0, (float)(sample * (double)0.3f * distanceSqPercentage));
                    }
                }
            }
        }
        t.draw();
        GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.disableState(State.BLEND);
        GLRenderer.globalSetLightEnabled(false);
    }

    private void renderAuroraBeam(@NotNull TessellatorGeneral tessellator, double x, double y, double z, double xOffset, double zOffset, float redOffset, float greenOffset, float blueOffset, double scale, float transparency) {
        float width = 16.0f;
        tessellator.setColor4f(0.0f + redOffset, 1.0f + greenOffset, 0.49803922f + blueOffset, transparency);
        tessellator.addVertexWithUV(x - xOffset * scale * (double)width, y - scale * 256.0, z - zOffset * scale * (double)width, 1.0, 1.0);
        tessellator.addVertexWithUV(x - xOffset * scale * (double)width, y + scale, z - zOffset * scale * (double)width, 1.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * (double)width, y + scale, z + zOffset * scale * (double)width, 0.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * (double)width, y - scale * 256.0, z + zOffset * scale * (double)width, 0.0, 1.0);
    }

    public void renderEntities(ICamera camera, float partialTick) {
        Entity entity;
        int i;
        if (this.noEntityRenderFrames > 0) {
            --this.noEntityRenderFrames;
            return;
        }
        TileEntityRenderDispatcher.instance.cacheActiveRenderInfo(this.world, camera, partialTick);
        EntityRendererDispatcher.instance.cacheActiveRenderInfo(this.world, camera, partialTick);
        this.totalEntities = 0;
        this.renderedEntities = 0;
        this.culledEntities = 0;
        EntityRendererDispatcher.renderPosX = camera.getX(partialTick);
        EntityRendererDispatcher.renderPosY = camera.getY(partialTick);
        EntityRendererDispatcher.renderPosZ = camera.getZ(partialTick);
        TileEntityRenderDispatcher.renderPosX = camera.getX(partialTick);
        TileEntityRenderDispatcher.renderPosY = camera.getY(partialTick);
        TileEntityRenderDispatcher.renderPosZ = camera.getZ(partialTick);
        List<Entity> loadedEntities = this.world.getLoadedEntityList();
        this.totalEntities = loadedEntities.size();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        Vector3dc cameraPos = camera.getPosition(partialTick);
        for (i = 0; i < this.world.weatherEffects.size(); ++i) {
            entity = (Entity)this.world.weatherEffects.get(i);
            ++this.renderedEntities;
            if ((!entity.shouldRender(cameraPos, 1.0) || !camera.getFrustum().isVisible(entity.bb, partialTick)) && this.mc.thePlayer.vehicle != entity) continue;
            EntityRendererDispatcher.instance.renderEntity(tessellator, entity, partialTick);
        }
        for (i = 0; i < loadedEntities.size(); ++i) {
            ICamera iCamera;
            entity = loadedEntities.get(i);
            if (this.mc.activeCamera != null && (iCamera = this.mc.activeCamera) instanceof EntityCamera) {
                EntityCamera entityCamera = (EntityCamera)iCamera;
                if (entityCamera.mob == entity && !this.mc.activeCamera.showPlayer()) continue;
            }
            if (this.mc.thePlayer.vehicle != entity && (!entity.shouldRender(cameraPos, ((Float)this.mc.gameSettings.entityRenderDistance.value).floatValue()) || !entity.ignoreFrustumCheck && !camera.getFrustum().isVisible(EntityRendererDispatcher.instance.getRenderer(entity).entityViewBox(entity), partialTick))) continue;
            int floorY = MathHelper.floor(entity.y);
            if (floorY < 0) {
                floorY = 0;
            }
            if (floorY >= this.world.getHeightBlocks()) {
                floorY = this.world.getHeightBlocks() - 1;
            }
            if (!this.world.isBlockLoaded(MathHelper.floor(entity.x), floorY, MathHelper.floor(entity.z)) && this.mc.thePlayer.vehicle != entity) continue;
            ++this.renderedEntities;
            EntityRendererDispatcher.instance.renderEntity(tessellator, entity, partialTick);
        }
        int tileEntitiesSize = this.renderableTileEntities.size();
        for (i = 0; i < tileEntitiesSize; ++i) {
            TileEntity tileEntity = this.renderableTileEntities.get(i);
            TileEntityRenderDispatcher.instance.renderTileEntity(tessellator, camera, tileEntity, partialTick);
        }
    }

    public String getRendererDebugInfo() {
        return "C: " + this.renderedChunks + "/" + this.totalChunks + ". F: " + this.offscreenChunks + ", O: " + this.occludedChunks + ", E: " + this.emptyChunks;
    }

    public String getEntityDebugInfo() {
        return "E: " + this.renderedEntities + "/" + this.totalEntities + ". B: " + this.culledEntities + ", I: " + (this.totalEntities - this.culledEntities - this.renderedEntities);
    }

    public void resortChunks(int xc, int yc, int zc) {
        xc -= 8;
        zc -= 8;
        this.xMinChunk = Integer.MAX_VALUE;
        this.yMinChunk = Integer.MAX_VALUE;
        this.zMinChunk = Integer.MAX_VALUE;
        this.xMaxChunk = Integer.MIN_VALUE;
        this.yMaxChunk = Integer.MIN_VALUE;
        this.zMaxChunk = Integer.MIN_VALUE;
        int s2 = this.xChunks * 16;
        int s1 = s2 / 2;
        for (int x = 0; x < this.xChunks; ++x) {
            int xx = x * 16;
            int xOff = xx + s1 - xc;
            if (xOff < 0) {
                xOff -= s2 - 1;
            }
            if ((xx -= (xOff /= s2) * s2) < this.xMinChunk) {
                this.xMinChunk = xx;
            }
            if (xx > this.xMaxChunk) {
                this.xMaxChunk = xx;
            }
            for (int z = 0; z < this.zChunks; ++z) {
                int zz = z * 16;
                int zOff = zz + s1 - zc;
                if (zOff < 0) {
                    zOff -= s2 - 1;
                }
                if ((zz -= (zOff /= s2) * s2) < this.zMinChunk) {
                    this.zMinChunk = zz;
                }
                if (zz > this.zMaxChunk) {
                    this.zMaxChunk = zz;
                }
                for (int y = 0; y < this.yChunks; ++y) {
                    int yy = y * 16;
                    if (yy < this.yMinChunk) {
                        this.yMinChunk = yy;
                    }
                    if (yy > this.yMaxChunk) {
                        this.yMaxChunk = yy;
                    }
                    ChunkRenderer renderer = this.chunkRenderers[(z * this.yChunks + y) * this.xChunks + x];
                    boolean wasDirty = renderer.dirty;
                    renderer.setPos(xx, yy, zz);
                    if (wasDirty || !renderer.dirty) continue;
                    this.dirtyChunks.add(renderer);
                }
            }
        }
    }

    public int render(ICamera camera, int renderPass, double partialTick) {
        double zd;
        double yd;
        double xd;
        for (int i = 0; i < 10; ++i) {
            this.chunkFixOffs = (this.chunkFixOffs + 1) % this.chunkRenderers.length;
            ChunkRenderer chunkRenderer = this.chunkRenderers[this.chunkFixOffs];
            if (!chunkRenderer.dirty || this.dirtyChunks.contains(chunkRenderer)) continue;
            this.dirtyChunks.add(chunkRenderer);
        }
        if ((Integer)this.mc.gameSettings.renderDistance.value != this.renderDistance) {
            this.allChanged();
        }
        if (renderPass == 0) {
            this.totalChunks = 0;
            this.offscreenChunks = 0;
            this.occludedChunks = 0;
            this.renderedChunks = 0;
            this.emptyChunks = 0;
        }
        if ((xd = camera.getX() - this.xOld) * xd + (yd = camera.getY() - this.yOld) * yd + (zd = camera.getZ() - this.zOld) * zd > 16.0) {
            this.xOld = camera.getX();
            this.yOld = camera.getY();
            this.zOld = camera.getZ();
            this.resortChunks(MathHelper.floor(camera.getX()), MathHelper.floor(camera.getY()), MathHelper.floor(camera.getZ()));
        }
        Lighting.disable();
        return 0;
    }

    public void tick() {
        float windDirection = this.world.worldType.getWindManager().getWindDirection(this.world, 0.0f, 500.0f, 0.0f);
        float windIntensity = this.world.worldType.getWindManager().getWindIntensity(this.world, 0.0f, 500.0f, 0.0f);
        float dx = -((float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        float dz = -((float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        this.cloudVelocityX += dx;
        this.cloudVelocityZ += dz;
        float maxVel = 1.5f;
        if (this.cloudVelocityX > maxVel) {
            this.cloudVelocityX = maxVel;
        }
        if (this.cloudVelocityX < -maxVel) {
            this.cloudVelocityX = -maxVel;
        }
        if (this.cloudVelocityZ > maxVel) {
            this.cloudVelocityZ = maxVel;
        }
        if (this.cloudVelocityZ < -maxVel) {
            this.cloudVelocityZ = -maxVel;
        }
        this.lastCloudOffsetX = this.cloudOffsetX;
        this.lastCloudOffsetZ = this.cloudOffsetZ;
        this.cloudOffsetX += this.cloudVelocityX;
        this.cloudOffsetZ += this.cloudVelocityZ;
        ++this.ticks;
    }

    public void renderSky(float partialTick) {
        WorldTypeFX worldTypeFX = (WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType());
        if (!worldTypeFX.hasSky() || this.mc.currentScreen instanceof ScreenModelViewer) {
            return;
        }
        float celestialAngle = this.world.getCelestialAngle(partialTick);
        GLRenderer.pushFrame();
        this.mc.worldRenderer.fogManager.setupFog(-1, this.mc.worldRenderer.farPlaneDistance, partialTick, GLRenderer.getFogState());
        GLRenderer.setShader(Shaders.COLOR_WORLD);
        Vector3fc skyColor = this.world.getSkyColor(this.mc.activeCamera, partialTick);
        float r = skyColor.x();
        float g = skyColor.y();
        float b = skyColor.z();
        GLRenderer.setDepthMask(false);
        GLRenderer.setColor3f(r, g, b);
        GLRenderer.render(this.skyBuffer);
        GLRenderer.popFrame();
        GLRenderer.pushFrame();
        GLRenderer.getFogState().disable();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        Lighting.disable();
        TessellatorShader t = GLRenderer.getTessellator();
        float[] sunriseColor = worldTypeFX.getSunriseColor(celestialAngle, partialTick);
        if (sunriseColor != null) {
            GLRenderer.pushFrame();
            GLRenderer.setDepthMask(false);
            GLRenderer.setShader(Shaders.COLOR);
            GLRenderer.modelM4f().rotateY(org.joml.Math.toRadians(-90.0f));
            GLRenderer.modelM4f().rotateX(org.joml.Math.toRadians(90.0f));
            GLRenderer.modelM4f().rotateZ(org.joml.Math.toRadians(celestialAngle <= 0.5f ? 0.0f : 180.0f));
            float sr = sunriseColor[0];
            float sg = sunriseColor[1];
            float sb = sunriseColor[2];
            t.startDrawing(DrawMode.TRIANGLE_FAN);
            t.setColor4f(sr, sg, sb, sunriseColor[3]);
            t.addVertex(0.0, 100.0, 0.0);
            int numVertices = 16;
            t.setColor4f(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f);
            for (int i = 0; i <= numVertices; ++i) {
                float theta = (float)i * (float)Math.PI * 2.0f / (float)numVertices;
                float sunriseX = MathHelper.sin(theta);
                float sunriseYZ = MathHelper.cos(theta);
                t.addVertex(sunriseX * 120.0f, sunriseYZ * 120.0f, -sunriseYZ * 40.0f * sunriseColor[3]);
            }
            t.draw();
            GLRenderer.popFrame();
        }
        GLRenderer.popFrame();
        GLRenderer.pushFrame();
        GLRenderer.setDepthMask(false);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE);
        float sunAlpha = 1.0f - (this.world.getCurrentWeather() != null && this.world.getCurrentWeather() != Weathers.OVERWORLD_CLEAR ? this.world.weatherManager.getWeatherIntensity() * this.world.weatherManager.getWeatherPower() * 1.5f : 0.0f);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        GLRenderer.modelM4f().translate(x, y, z);
        GLRenderer.modelM4f().rotateZ(org.joml.Math.toRadians(celestialAngle * 360.0f));
        float size = 30.0f;
        this.textureManager.loadTexture("/assets/minecraft/textures/terrain/sun.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, sunAlpha);
        t.startDrawingQuads();
        t.addVertexWithUV(-size, 100.0, -size, 0.0, 0.0);
        t.addVertexWithUV(size, 100.0, -size, 1.0, 0.0);
        t.addVertexWithUV(size, 100.0, size, 1.0, 1.0);
        t.addVertexWithUV(-size, 100.0, size, 0.0, 1.0);
        t.draw();
        if (this.world.rainbowTicks > 0 || !Double.isNaN(this.rainbowBrightness) && this.rainbowBrightness > 0.0) {
            float timeScalar;
            float halfRainbowLength = (float)this.world.startingRainbowTicks / 2.0f;
            float rainbowTimeScalar = 1.0f - Math.abs((float)this.world.rainbowTicks + partialTick - halfRainbowLength) / halfRainbowLength;
            float angDeg = celestialAngle * 360.0f;
            if (angDeg >= 0.0f && angDeg < 180.0f) {
                angDiff = MathHelper.deltaAngle(angDeg, 80.0);
                timeScalar = 1.0f - (float)(Math.sqrt(angDiff * angDiff) / 90.0);
            } else {
                angDiff = MathHelper.deltaAngle(angDeg, 280.0);
                timeScalar = 1.0f - (float)(Math.sqrt(angDiff * angDiff) / 90.0);
            }
            float cutoff = 2.25f;
            timeScalar -= 0.5555556f;
            if (timeScalar < 0.0f) {
                timeScalar = 0.0f;
            }
            timeScalar *= 2.25f;
            timeScalar *= rainbowTimeScalar;
            Weather[] blocked = this.world.getBlockBiome((TilePosc)new TilePos((Entity)this.mc.thePlayer)).blockedWeathers;
            boolean isWeatherBlocked = false;
            for (Weather w : blocked) {
                if (!w.equals(this.world.weatherManager.getLastWeather())) continue;
                isWeatherBlocked = true;
                break;
            }
            double targetRainbowBrightness = isWeatherBlocked ? 0.0 : (double)timeScalar;
            if (Double.isNaN(this.rainbowBrightness)) {
                this.rainbowBrightness = targetRainbowBrightness;
            }
            double totalDelta = targetRainbowBrightness - this.rainbowBrightness;
            double rainbowBrightnessDelta = totalDelta / 100.0;
            this.rainbowBrightness += rainbowBrightnessDelta * (double)partialTick;
            this.textureManager.loadTexture("/assets/minecraft/textures/terrain/rainbow.png").bind();
            t.startDrawingQuads();
            int iterations = 10;
            for (int i = 0; i < 10; ++i) {
                size = 200.0f - (float)(i * 4);
                int color = Color.HSBtoRGB((float)i / 10.0f, 1.0f, (float)((double)0.3f * this.rainbowBrightness));
                float rainbowAlpha = (float)((double)(0.35f - 0.15f * (float)Math.abs(i - 5) / 5.0f) * this.rainbowBrightness);
                t.setColor4f((float)net.minecraft.core.util.helper.Color.redFromInt(color) / 255.0f, (float)net.minecraft.core.util.helper.Color.greenFromInt(color) / 255.0f, (float)net.minecraft.core.util.helper.Color.blueFromInt(color) / 255.0f, rainbowAlpha);
                t.addVertexWithUV(-size, -100.0, size, 1.0, 1.0);
                t.addVertexWithUV(size, -100.0, size, 0.0, 1.0);
                t.addVertexWithUV(size, -100.0, -size, 0.0, 0.0);
                t.addVertexWithUV(-size, -100.0, -size, 1.0, 0.0);
            }
            t.draw();
        } else {
            this.rainbowBrightness = 0.0;
        }
        size = 20.0f;
        this.textureManager.loadTexture("/assets/minecraft/textures/terrain/moon.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, sunAlpha);
        t.startDrawingQuads();
        t.addVertexWithUV(-size, -100.0, size, 1.0, 1.0);
        t.addVertexWithUV(size, -100.0, size, 0.0, 1.0);
        t.addVertexWithUV(size, -100.0, -size, 0.0, 0.0);
        t.addVertexWithUV(-size, -100.0, -size, 1.0, 0.0);
        t.draw();
        float starVis = this.world.getStarBrightness(partialTick) * sunAlpha * sunAlpha * sunAlpha;
        if (starVis > 0.0f) {
            this.textureManager.loadTexture("/assets/minecraft/textures/colormap/stars/default.png").bind();
            GLRenderer.setColor4f(starVis, starVis, starVis, starVis);
            GLRenderer.render(this.starBuffer);
        }
        GLRenderer.popFrame();
    }

    private float getCloudHeightModifier() {
        return ((Float)this.mc.gameSettings.cloudHeight.value).floatValue() * 128.0f;
    }

    public void renderClouds(float partialTick) {
        WorldTypeFX worldTypeFX = (WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType());
        if (!worldTypeFX.hasClouds()) {
            return;
        }
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            return;
        }
        if ((Integer)this.mc.gameSettings.fancyGraphics.value == 1) {
            this.renderCloudsFancy(partialTick);
            return;
        }
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.CLOUDS);
        GLRenderer.setLightmapCoord2i(15, 15);
        GLRenderer.disableState(State.CULL_FACE);
        float cameraY = (float)this.mc.activeCamera.getY(partialTick);
        int cloudRadius = 32;
        int i = 256 / cloudRadius;
        TessellatorShader tessellator = GLRenderer.getTessellator();
        this.textureManager.loadTexture("/assets/minecraft/textures/environment/clouds.png").bind();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        Vector3fc dimensionColor = this.world.getDimensionColor(this.mc.activeCamera, partialTick);
        float r = dimensionColor.x();
        float g = dimensionColor.y();
        float b = dimensionColor.z();
        float f6 = 4.8828125E-4f;
        double posX = this.mc.activeCamera.getX(partialTick) + (double)(org.joml.Math.lerp(this.lastCloudOffsetX, this.cloudOffsetX, partialTick) * 0.03f);
        double posZ = this.mc.activeCamera.getZ(partialTick) + (double)(org.joml.Math.lerp(this.lastCloudOffsetZ, this.cloudOffsetZ, partialTick) * 0.03f);
        int j = MathHelper.floor(posX / 2048.0);
        int k = MathHelper.floor(posZ / 2048.0);
        float cloudHeight = worldTypeFX.getCloudHeight() - cameraY + 0.33f + this.getCloudHeightModifier();
        float f10 = (float)((posX -= (double)(j * 2048)) * (double)f6);
        float f11 = (float)((posZ -= (double)(k * 2048)) * (double)f6);
        tessellator.startDrawingQuads();
        tessellator.setColor4f(r, g, b, 0.8f);
        int dist = cloudRadius * i * 2;
        int cloudZ = -cloudRadius * i;
        int cloudX = -cloudRadius * i;
        tessellator.addVertexWithUV(cloudX, cloudHeight, cloudZ + cloudRadius * dist, (float)cloudX * f6 + f10, (float)(cloudZ + cloudRadius * dist) * f6 + f11);
        tessellator.addVertexWithUV(cloudX + cloudRadius * dist, cloudHeight, cloudZ + cloudRadius * dist, (float)(cloudX + cloudRadius * dist) * f6 + f10, (float)(cloudZ + cloudRadius * dist) * f6 + f11);
        tessellator.addVertexWithUV(cloudX + cloudRadius * dist, cloudHeight, cloudZ, (float)(cloudX + cloudRadius * dist) * f6 + f10, (float)cloudZ * f6 + f11);
        tessellator.addVertexWithUV(cloudX, cloudHeight, cloudZ, (float)cloudX * f6 + f10, (float)cloudZ * f6 + f11);
        tessellator.draw();
        GLRenderer.disableState(State.BLEND);
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.popFrame();
    }

    public void renderCloudsFancy(float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.setLightmapCoord2i(15, 15);
        WorldTypeFX worldTypeFX = (WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType());
        this.mc.renderer.beginRenderClouds(partialTick);
        float celestialAngle = this.world.getCelestialAngle(partialTick);
        float[] sunriseColor = worldTypeFX.getSunriseColor(celestialAngle, partialTick);
        float rSun = 0.0f;
        float gSun = 0.0f;
        float bSun = 0.0f;
        float aSun = 0.0f;
        if (sunriseColor != null) {
            rSun = sunriseColor[0];
            gSun = sunriseColor[1];
            bSun = sunriseColor[2];
            aSun = sunriseColor[3] / 2.0f;
        }
        Vector3fc dimensionColor = this.world.getDimensionColor(this.mc.activeCamera, partialTick);
        float rDim = dimensionColor.x();
        float gDim = dimensionColor.y();
        float bDim = dimensionColor.z();
        GLRenderer.disableState(State.CULL_FACE);
        float cameraY = (float)this.mc.activeCamera.getY(partialTick);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        float cloudWidth = 12.0f;
        float cloudThickness = 4.0f;
        double dx = (this.mc.activeCamera.getX(partialTick) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * partialTick) * 0.03f)) / (double)cloudWidth;
        double dz = (this.mc.activeCamera.getZ(partialTick) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * partialTick) * 0.03f)) / (double)cloudWidth + 0.33;
        float dy = worldTypeFX.getCloudHeight() - cameraY + 0.33f + this.getCloudHeightModifier();
        int i = MathHelper.floor(dx / 2048.0);
        int j = MathHelper.floor(dz / 2048.0);
        dx -= (double)(i * 2048);
        dz -= (double)(j * 2048);
        this.textureManager.loadTexture("/assets/minecraft/textures/environment/clouds.png").bind();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        float f13 = 0.00390625f;
        float f9 = (float)MathHelper.floor(dx) * f13;
        float f11 = (float)MathHelper.floor(dz) * f13;
        float f14 = (float)(dx - (double)MathHelper.floor(dx));
        float f15 = (float)(dz - (double)MathHelper.floor(dz));
        int cloudWidthScale = 8;
        int radius = 3;
        float f16 = 9.765625E-4f;
        GLRenderer.modelM4f().scale(cloudWidth, 1.0f, cloudWidth);
        float red = rDim + (rSun - rDim) * aSun;
        float green = gDim + (gSun - gDim) * aSun;
        float blue = bDim + (bSun - bDim) * aSun;
        tessellator.startDrawingQuads();
        float width = (radius * 2 + 2) * cloudWidthScale;
        float minX = (-radius - 1) * cloudWidthScale;
        float minZ = (-radius - 1) * cloudWidthScale;
        float cloudX = minX - f14;
        float cloudZ = minZ - f15;
        if (dy > -cloudThickness - 1.0f) {
            tessellator.setColor4f(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + width, (minX + 0.0f) * f13 + f9, (minZ + width) * f13 + f11);
            tessellator.addVertexWithUV(cloudX + width, dy + 0.0f, cloudZ + width, (minX + width) * f13 + f9, (minZ + width) * f13 + f11);
            tessellator.addVertexWithUV(cloudX + width, dy + 0.0f, cloudZ + 0.0f, (minX + width) * f13 + f9, (minZ + 0.0f) * f13 + f11);
            tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + 0.0f, (minX + 0.0f) * f13 + f9, (minZ + 0.0f) * f13 + f11);
        }
        if (dy <= cloudThickness + 1.0f) {
            tessellator.setColor4f(red, green, blue, 0.8f);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + width, (minX + 0.0f) * f13 + f9, (minZ + width) * f13 + f11);
            tessellator.addVertexWithUV(cloudX + width, dy + cloudThickness - f16, cloudZ + width, (minX + width) * f13 + f9, (minZ + width) * f13 + f11);
            tessellator.addVertexWithUV(cloudX + width, dy + cloudThickness - f16, cloudZ + 0.0f, (minX + width) * f13 + f9, (minZ + 0.0f) * f13 + f11);
            tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + 0.0f, (minX + 0.0f) * f13 + f9, (minZ + 0.0f) * f13 + f11);
        }
        for (int ix = -radius - 1; ix <= radius + 1; ++ix) {
            for (int iz = -radius - 1; iz <= radius + 1; ++iz) {
                float f17 = ix * cloudWidthScale;
                float f18 = iz * cloudWidthScale;
                float cloudX2 = f17 - f14;
                float cloudZ2 = f18 - f15;
                tessellator.setColor4f(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                if (ix > -1) {
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    for (int k1 = 0; k1 < cloudWidthScale; ++k1) {
                        tessellator.addVertexWithUV(cloudX2 + (float)k1 + 0.0f, dy + 0.0f, cloudZ2 + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)k1 + 0.0f, dy + cloudThickness, cloudZ2 + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)k1 + 0.0f, dy + cloudThickness, cloudZ2 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)k1 + 0.0f, dy + 0.0f, cloudZ2 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                } else {
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    for (int l1 = 0; l1 < cloudWidthScale; ++l1) {
                        tessellator.addVertexWithUV(cloudX2 + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ2 + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ2 + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ2 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ2 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                }
                tessellator.setColor4f(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                if (iz > -1) {
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    for (int i2 = 0; i2 < cloudWidthScale; ++i2) {
                        tessellator.addVertexWithUV(cloudX2 + 0.0f, dy + cloudThickness, cloudZ2 + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)cloudWidthScale, dy + cloudThickness, cloudZ2 + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + (float)cloudWidthScale, dy + 0.0f, cloudZ2 + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX2 + 0.0f, dy + 0.0f, cloudZ2 + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                    }
                    continue;
                }
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                for (int j2 = 0; j2 < cloudWidthScale; ++j2) {
                    tessellator.addVertexWithUV(cloudX2 + 0.0f, dy + cloudThickness, cloudZ2 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                    tessellator.addVertexWithUV(cloudX2 + (float)cloudWidthScale, dy + cloudThickness, cloudZ2 + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                    tessellator.addVertexWithUV(cloudX2 + (float)cloudWidthScale, dy + 0.0f, cloudZ2 + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                    tessellator.addVertexWithUV(cloudX2 + 0.0f, dy + 0.0f, cloudZ2 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                }
            }
        }
        GLRenderer.setShader(Shaders.CLOUDS);
        GLRenderer.setColorMask(false, false, false, true);
        tessellator.draw();
        GLRenderer.setColorMask(true, true, true, true);
        GLRenderer.getShader().bind();
        GL41.glBindVertexArray(tessellator.vaos[tessellator.config]);
        GL41.glBindBuffer(34962, tessellator.vbos[tessellator.config]);
        GL41.glDrawArrays(tessellator.drawMode.cap, 0, tessellator.vertexCount);
        GL41.glBindVertexArray(0);
        GLRenderer.popFrame();
        this.mc.renderer.endRenderClouds(partialTick);
    }

    public boolean updateDirtyChunks(@NotNull ICamera camera) {
        int i;
        this.dirtyChunkRendererSorter.setActiveCamera(camera);
        Arrays.fill(this.toAdd, null);
        this.nearChunks.clear();
        int pendingChunkSize = this.dirtyChunks.size();
        for (i = 0; i < pendingChunkSize; ++i) {
            ChunkRenderer renderer = this.dirtyChunks.get(i);
            if (renderer.distanceToCameraSquared(camera) > 2048.0f) {
                int index;
                for (index = 0; index < 6 && (this.toAdd[index] == null || this.dirtyChunkRendererSorter.compare(this.toAdd[index], renderer) <= 0); ++index) {
                }
                if (--index <= 0) continue;
                int x = index;
                while (--x != 0) {
                    this.toAdd[x - 1] = this.toAdd[x];
                }
                this.toAdd[index] = renderer;
                continue;
            }
            this.nearChunks.add(renderer);
        }
        if (!this.nearChunks.isEmpty()) {
            if (this.nearChunks.size() > 1) {
                this.nearChunks.sort(this.dirtyChunkRendererSorter);
            }
            for (ChunkRenderer renderer : this.nearChunks) {
                if (!renderer.rebuild(true)) continue;
                renderer.dirty = false;
                this.dirtyChunks.remove(renderer);
            }
        }
        for (i = 5; i >= 0; --i) {
            ChunkRenderer chunkx = this.toAdd[i];
            if (chunkx == null) continue;
            if (!chunkx.visible && i != 5) {
                this.toAdd[i] = null;
                break;
            }
            if (!chunkx.rebuild(false)) continue;
            chunkx.dirty = false;
            this.dirtyChunks.remove(chunkx);
        }
        return this.dirtyChunks.isEmpty();
    }

    public void drawBlockBreaking(@NotNull ICamera camera, @NotNull HitResult.Tile tileHit, float partialTick) {
        GLRenderer.pushFrame();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, (MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f);
        if (this.destroyProgress > 0.0f) {
            GLRenderer.setBlendFunc(BlendFactor.DST_COLOR, BlendFactor.SRC_COLOR);
            TextureRegistry.worldAtlas.bind();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 0.25f);
            GLRenderer.pushFrame();
            int k = this.world.getBlockId(tileHit.tilePos);
            Block<?> block = k <= 0 ? null : Blocks.blocksList[k];
            GLRenderer.setPolygonOffset(-3.0f, -3.0f);
            GLRenderer.enableState(State.POLYGON_OFFSET_FILL);
            double x = camera.getX(partialTick);
            double y = camera.getY(partialTick);
            double z = camera.getZ(partialTick);
            if (block == null) {
                block = Blocks.STONE;
            }
            tessellator.startDrawingQuads();
            tessellator.setTranslation(-x, -y, -z);
            tessellator.lockColor();
            tessellator.setLightmapCoord1i(LightmapHelper.getLightmapCoord(15, 0));
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderWithOverrideTexture(tessellator, this.world, tileHit.tilePos, breakingAnimation[MathHelper.clamp((int)(this.destroyProgress * 10.0f), 0, breakingAnimation.length - 1)]);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            GLRenderer.popFrame();
        }
        GLRenderer.popFrame();
    }

    public void drawSelectionBox(ICamera camera, HitResult hitResult, float partialTick) {
        if (this.mc.gameSettings.immersiveMode.drawOutline() && ((Float)this.mc.gameSettings.blockOutlineWidth.value).floatValue() > 0.01f && !(this.mc.currentScreen instanceof ScreenModelViewer)) {
            GLRenderer.pushFrame();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            float w = this.mc.getOutlineWidth();
            GLRenderer.setColor4f(0.0f, 0.0f, 0.0f, 0.35f + w * 0.3f);
            GLRenderer.setLineWidth(org.joml.Math.max(4.0f * w * 2.0f, 1.0f));
            GLRenderer.setShader(Shaders.LINES);
            GLRenderer.setDepthMask(false);
            double offsetX = camera.getX(partialTick);
            double offsetY = camera.getY(partialTick);
            double offsetZ = camera.getZ(partialTick);
            if (hitResult instanceof HitResult.Tile) {
                HitResult.Tile hitTile = (HitResult.Tile)hitResult;
                float expand = 0.002f;
                Block<?> block = this.world.getBlock(hitTile.tilePos);
                if (block != null) {
                    BoundingVolume volume = block.getBoundingVolume(this.world, hitTile.tilePos);
                    if (volume != null) {
                        this.drawOutlinedVolume(volume, (double)hitTile.tilePos.x() - offsetX, (double)hitTile.tilePos.y() - offsetY, (double)hitTile.tilePos.z() - offsetZ, expand);
                    } else {
                        AABBd selectionBB = MathHelper.aabbGrow(block.getSelectionAABB(this.world, hitTile.tilePos), expand, expand, expand, new AABBd());
                        selectionBB.translate(-offsetX, -offsetY, -offsetZ);
                        this.drawOutlinedBoundingBox(selectionBB);
                    }
                    if (((Boolean)this.mc.gameSettings.viewSupportMode.value).booleanValue()) {
                        TessellatorShader t = GLRenderer.getTessellator();
                        double x = (double)hitTile.tilePos.x() - offsetX;
                        double y = (double)hitTile.tilePos.y() - offsetY;
                        double z = (double)hitTile.tilePos.z() - offsetZ;
                        double oMin = -0.01;
                        double oMax = 1.01;
                        ISupport sBottom = block.getSupport(this.world, hitTile.tilePos, Side.BOTTOM);
                        ISupport sTop = block.getSupport(this.world, hitTile.tilePos, Side.TOP);
                        ISupport sNorth = block.getSupport(this.world, hitTile.tilePos, Side.NORTH);
                        ISupport sSouth = block.getSupport(this.world, hitTile.tilePos, Side.SOUTH);
                        ISupport sWest = block.getSupport(this.world, hitTile.tilePos, Side.WEST);
                        ISupport sEast = block.getSupport(this.world, hitTile.tilePos, Side.EAST);
                        t.startDrawingQuads();
                        if (sTop.canSupport(PartialSupport.INSTANCE.center(), Side.BOTTOM)) {
                            t.setColor4f(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMin + 0.25);
                        if (sTop.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM)) {
                            t.setColor4f(0.5f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        if (sTop.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMax - 0.25);
                        if (sTop.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMax, z + oMin + 0.25);
                        if (sTop.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMax, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.center(), Side.TOP)) {
                            t.setColor4f(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMax - 0.25);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.up(), Side.TOP)) {
                            t.setColor4f(0.5f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.down(), Side.TOP)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMin + 0.25);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.left(), Side.TOP)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMax - 0.25, y + oMin, z + oMin + 0.25);
                        if (sBottom.canSupport(PartialSupport.INSTANCE.right(), Side.TOP)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMin + 0.25);
                        t.addVertex(x + oMin + 0.25, y + oMin, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.center(), Side.SOUTH)) {
                            t.setColor4f(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.up(), Side.SOUTH)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.down(), Side.SOUTH)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.right(), Side.SOUTH)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMin);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        if (sNorth.canSupport(PartialSupport.INSTANCE.left(), Side.SOUTH)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMin);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMin);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.center(), Side.NORTH)) {
                            t.setColor4f(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.up(), Side.NORTH)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.down(), Side.NORTH)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.right(), Side.NORTH)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMax - 0.25, z + oMax);
                        t.addVertex(x + oMax - 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        if (sSouth.canSupport(PartialSupport.INSTANCE.left(), Side.NORTH)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMin + 0.25, z + oMax);
                        t.addVertex(x + oMin + 0.25, y + oMax - 0.25, z + oMax);
                        if (sWest.canSupport(PartialSupport.INSTANCE.center(), Side.EAST)) {
                            t.setColor4f(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMax - 0.25);
                        if (sWest.canSupport(PartialSupport.INSTANCE.up(), Side.EAST)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        if (sWest.canSupport(PartialSupport.INSTANCE.down(), Side.EAST)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMin + 0.25);
                        if (sWest.canSupport(PartialSupport.INSTANCE.left(), Side.EAST)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax, z + oMin);
                        t.addVertex(x + oMin, y + oMin, z + oMin);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMin + 0.25);
                        if (sWest.canSupport(PartialSupport.INSTANCE.right(), Side.EAST)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMin, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMin, y + oMin, z + oMax);
                        t.addVertex(x + oMin, y + oMax, z + oMax);
                        if (sEast.canSupport(PartialSupport.INSTANCE.center(), Side.WEST)) {
                            t.setColor4f(0.0f, 1.0f, 0.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMin + 0.25);
                        if (sEast.canSupport(PartialSupport.INSTANCE.up(), Side.WEST)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMin + 0.25);
                        if (sEast.canSupport(PartialSupport.INSTANCE.down(), Side.WEST)) {
                            t.setColor4f(0.0f, 1.0f, 0.5f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 0.5f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        if (sEast.canSupport(PartialSupport.INSTANCE.left(), Side.WEST)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMax - 0.25);
                        t.addVertex(x + oMax, y + oMax, z + oMax);
                        t.addVertex(x + oMax, y + oMin, z + oMax);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMax - 0.25);
                        if (sEast.canSupport(PartialSupport.INSTANCE.right(), Side.WEST)) {
                            t.setColor4f(0.0f, 1.0f, 1.0f, 0.25f);
                        } else {
                            t.setColor4f(1.0f, 0.0f, 1.0f, 0.25f);
                        }
                        t.addVertex(x + oMax, y + oMax, z + oMin);
                        t.addVertex(x + oMax, y + oMax - 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMin + 0.25, z + oMin + 0.25);
                        t.addVertex(x + oMax, y + oMin, z + oMin);
                        t.draw();
                    }
                }
            } else if (hitResult instanceof HitResult.Entity) {
                HitResult.Entity hitEntity = (HitResult.Entity)hitResult;
                if (hitEntity.entity.showBoundingBoxOnHover() && !((Boolean)this.mc.gameSettings.showCollisionBoxes.value).booleanValue()) {
                    this.drawInterpolatedEntityBoundingBox(hitEntity.entity, hitEntity.entity.bb, camera, partialTick);
                }
            }
            GLRenderer.popFrame();
        }
    }

    public void drawDebugEntityOutlines(ICamera camera, float partialTicks) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.LINES);
        GLRenderer.setLineWidth(2.0f);
        double offsetX = camera.getX(partialTicks);
        double offsetY = camera.getY(partialTicks);
        double offsetZ = camera.getZ(partialTicks);
        float expand = 0.002f;
        List<AABBdc> collidingBoundingBoxes = this.world.getCubes(this.mc.thePlayer, MathHelper.aabbGrow(this.mc.thePlayer.bb, expand, expand, expand, new AABBd()));
        GLRenderer.setColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        for (AABBdc aabb : collidingBoundingBoxes) {
            AABBd bb = aabb.translate(-offsetX, -offsetY, -offsetZ, new AABBd());
            MathHelper.aabbGrow(bb, expand, expand, expand, bb);
            this.drawOutlinedBoundingBox(bb);
        }
        float entityRadius = 10.0f;
        if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
            entityRadius = 100.0f;
        }
        List<Entity> entitiesNearby = this.world.getEntitiesWithinAABBExcludingEntity(null, MathHelper.aabbGrow(this.mc.thePlayer.bb, entityRadius, entityRadius, entityRadius, new AABBd()));
        for (Entity e : entitiesNearby) {
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.drawInterpolatedEntityBoundingBox(e, e.bb, camera, partialTicks);
            GLRenderer.setColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            AABBd head = new AABBd(e.bb);
            head.setMin(head.minX, e.y + (double)e.getHeadHeight() - 0.005, head.minZ).setMax(head.maxX, e.y + (double)e.getHeadHeight() + 0.005, head.maxZ);
            this.drawInterpolatedEntityBoundingBox(e, head, camera, partialTicks);
            GLRenderer.setColor4f(1.0f, 0.0f, 1.0f, 1.0f);
            AABBd feet = new AABBd(e.bb.minX, e.y - 0.005, e.bb.minZ, e.bb.maxX, e.y + 0.005, e.bb.maxZ);
            this.drawInterpolatedEntityBoundingBox(e, feet, camera, partialTicks);
            GLRenderer.setColor4f(0.75f, 0.75f, 1.0f, 1.0f);
            this.drawInterpolatedEntityBoundingBox(e, EntityRendererDispatcher.instance.getRenderer(e).entityViewBox(e), camera, partialTicks);
            double lerpOffsetX = MathHelper.lerp(e.xo, e.x, (double)partialTicks) - camera.getX(partialTicks);
            double lerpOffsetY = MathHelper.lerp(e.yo, e.y, (double)partialTicks) - camera.getY(partialTicks);
            double lerpOffsetZ = MathHelper.lerp(e.zo, e.z, (double)partialTicks) - camera.getZ(partialTicks);
            RenderGlobal.drawDebugVec(GLRenderer.getTessellator(), new Vector3d(lerpOffsetX, lerpOffsetY + (double)e.getHeadHeight(), lerpOffsetZ), e.getViewVector(partialTicks), 1.0, 0.0f, 1.0f, 0.0f, 1.0f);
        }
        GLRenderer.popFrame();
    }

    public static void drawDebugVec(@NotNull TessellatorGeneral tessellator, @NotNull Vector3dc pos, @Nullable Vector3dc vec, double scale, float r, float g, float b, float a) {
        if (vec == null) {
            return;
        }
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.LINES);
        GLRenderer.setLineWidth(10.0f);
        tessellator.startDrawing(DrawMode.LINES);
        tessellator.setColor4f(r, g, b, a);
        tessellator.addVertex(pos.x(), pos.y(), pos.z());
        tessellator.addVertex(pos.x() + vec.x() * scale, pos.y() + vec.y() * scale, pos.z() + vec.z() * scale);
        tessellator.draw();
        GLRenderer.popFrame();
    }

    public void drawInterpolatedEntityBoundingBox(@NotNull Entity entity, @NotNull AABBdc boundingBox, @NotNull ICamera camera, float partialTicks) {
        double cameraX = camera.getX(partialTicks);
        double cameraY = camera.getY(partialTicks);
        double cameraZ = camera.getZ(partialTicks);
        float expand = 0.02f;
        double lerpOffsetX = entity.xo + (entity.x - entity.xo) * (double)partialTicks;
        double lerpOffsetY = entity.yo + (entity.y - entity.yo) * (double)partialTicks;
        double lerpOffsetZ = entity.zo + (entity.z - entity.zo) * (double)partialTicks;
        AABBd bb = MathHelper.aabbGrow(boundingBox, expand, expand, expand, new AABBd());
        bb.translate(-entity.x, -entity.y, -entity.z);
        bb.translate(-cameraX, -cameraY, -cameraZ);
        bb.translate(lerpOffsetX, lerpOffsetY, lerpOffsetZ);
        this.drawOutlinedBoundingBox(bb);
    }

    public void drawDebugChunkBorders(@NotNull ICamera camera, float partialTicks) {
        int i;
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.LINES);
        double offsetX = camera.getX(partialTicks);
        double offsetY = camera.getY(partialTicks);
        double offsetZ = camera.getZ(partialTicks);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.setTranslation(-offsetX, -offsetY, -offsetZ);
        int blockX = MathHelper.floor(this.mc.thePlayer.x);
        int blockZ = MathHelper.floor(this.mc.thePlayer.z);
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        int x0 = chunkX << 4;
        int z0 = chunkZ << 4;
        int x1 = x0 + 16;
        int z1 = z0 + 16;
        int worldHeight = this.mc.currentWorld.getHeightBlocks();
        GLRenderer.setLineWidth(2.0f);
        GLRenderer.setColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        tessellator.startDrawing(DrawMode.LINES);
        for (i = -1; i <= 2; ++i) {
            for (int j = -1; j <= 2; ++j) {
                int x2 = chunkX + i << 4;
                int z2 = chunkZ + j << 4;
                tessellator.addVertex(x2, 0.0, z2);
                tessellator.addVertex(x2, worldHeight, z2);
            }
        }
        tessellator.draw();
        GLRenderer.setLineWidth(1.0f);
        GLRenderer.setColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        tessellator.startDrawing(DrawMode.LINES);
        for (int y = 0; y <= worldHeight; ++y) {
            if (y % 2 == 1) continue;
            tessellator.addVertex(x0, y, z0);
            tessellator.addVertex(x1, y, z0);
            tessellator.addVertex(x0, y, z1);
            tessellator.addVertex(x1, y, z1);
            tessellator.addVertex(x0, y, z0);
            tessellator.addVertex(x0, y, z1);
            tessellator.addVertex(x1, y, z0);
            tessellator.addVertex(x1, y, z1);
        }
        for (i = 1; i < 16; ++i) {
            if (i % 2 == 1) continue;
            tessellator.addVertex(x0 + i, 0.0, z0);
            tessellator.addVertex(x0 + i, 256.0, z0);
            tessellator.addVertex(x0, 0.0, z0 + i);
            tessellator.addVertex(x0, 256.0, z0 + i);
            tessellator.addVertex(x0 + i, 0.0, z1);
            tessellator.addVertex(x0 + i, 256.0, z1);
            tessellator.addVertex(x1, 0.0, z0 + i);
            tessellator.addVertex(x1, 256.0, z0 + i);
        }
        tessellator.draw();
        tessellator.setTranslation(0.0, 0.0, 0.0);
        GLRenderer.popFrame();
    }

    public void drawOutlinedBoundingBox(@NotNull AABBdc aabb) {
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawing(DrawMode.LINE_STRIP);
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.draw();
        tessellator.startDrawing(DrawMode.LINE_STRIP);
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.draw();
        tessellator.startDrawing(DrawMode.LINES);
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.minZ());
        tessellator.addVertex(aabb.maxX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.minY(), aabb.maxZ());
        tessellator.addVertex(aabb.minX(), aabb.maxY(), aabb.maxZ());
        tessellator.draw();
    }

    public void drawOutlinedVolume(BoundingVolume volume, double xOffset, double yOffset, double zOffset, float expand) {
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawing(DrawMode.LINES);
        Float[] points = volume.getBakedLineCoords();
        for (int i = 0; i < points.length; i += 3) {
            float expand0 = (points[i].floatValue() - 0.5f) * 2.0f * expand;
            float expand1 = (points[i + 1].floatValue() - 0.5f) * 2.0f * expand;
            float expand2 = (points[i + 2].floatValue() - 0.5f) * 2.0f * expand;
            t.addVertex((double)points[i].floatValue() + xOffset + (double)expand0, (double)points[i + 1].floatValue() + yOffset + (double)expand1, (double)points[i + 2].floatValue() + zOffset + (double)expand2);
        }
        t.draw();
    }

    public void setDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        int _x0 = MathHelper.bucketInt(x0, 16);
        int _y0 = MathHelper.bucketInt(y0, 16);
        int _z0 = MathHelper.bucketInt(z0, 16);
        int _x1 = MathHelper.bucketInt(x1, 16);
        int _y1 = MathHelper.bucketInt(y1, 16);
        int _z1 = MathHelper.bucketInt(z1, 16);
        for (int x = _x0; x <= _x1; ++x) {
            int xx = x % this.xChunks;
            if (xx < 0) {
                xx += this.xChunks;
            }
            for (int y = _y0; y <= _y1; ++y) {
                int yy = y % this.yChunks;
                if (yy < 0) {
                    yy += this.yChunks;
                }
                for (int z = _z0; z <= _z1; ++z) {
                    int zz = z % this.zChunks;
                    if (zz < 0) {
                        zz += this.zChunks;
                    }
                    int p = (zz * this.yChunks + yy) * this.xChunks + xx;
                    ChunkRenderer renderer = this.chunkRenderers[p];
                    if (renderer.dirty) continue;
                    this.dirtyChunks.add(renderer);
                    renderer.setDirty();
                }
            }
        }
    }

    @Override
    public void blockChanged(int x, int y, int z) {
        this.setDirty(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void setBlocksDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.setDirty(x0 - 1, y0 - 1, z0 - 1, x1 + 1, y1 + 1, z1 + 1);
    }

    public void cull(CameraFrustum frustum, float partialTick) {
        for (int i = 0; i < this.chunkRenderers.length; ++i) {
            if (this.chunkRenderers[i].isEmpty() || this.chunkRenderers[i].visible && (i + this.cullStep & 0xF) != 0) continue;
            this.chunkRenderers[i].cull(frustum, partialTick);
        }
        ++this.cullStep;
    }

    @Override
    public void playStreamingMusic(String soundPath, String author, int x, int y, int z) {
        if (soundPath != null) {
            if (author != null && !author.isEmpty()) {
                this.mc.hudIngame.setRecordPlayingMessage(author + " - " + I18n.getInstance().translateKey(soundPath));
            } else {
                this.mc.hudIngame.setRecordPlayingMessage(I18n.getInstance().translateKey(soundPath));
            }
        }
        this.mc.sndManager.playMusic(soundPath, (float)x, (float)y, (float)z, 1.0f, 1.0f);
    }

    @Override
    public void playSound(Entity player, String soundPath, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        this.mc.sndManager.playSoundAt(soundPath, category, (float)x, (float)y, (float)z, volume, pitch);
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
        this.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, 16.0);
    }

    @Override
    public void addParticle(String particleId, double x, double y, double z, double motionX, double motionY, double motionZ, int data, double maxDistance) {
        double d8;
        double d7;
        if (this.mc == null || this.mc.activeCamera == null || this.mc.particleEngine == null) {
            return;
        }
        double d6 = this.mc.activeCamera.getX() - x;
        if (d6 * d6 + (d7 = this.mc.activeCamera.getY() - y) * d7 + (d8 = this.mc.activeCamera.getZ() - z) * d8 > maxDistance * maxDistance) {
            return;
        }
        Particle fx = ((ParticleLambda)ParticleDispatcher.getInstance().getDispatch(particleId)).newParticle(this.world, x, y, z, motionX, motionY, motionZ, data);
        if (fx != null) {
            this.mc.particleEngine.add(fx);
        }
    }

    @Override
    public void allChanged(boolean lightChanged, boolean seasonChanged) {
        if (seasonChanged) {
            Colorizers.update(false);
        }
        if (seasonChanged) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                if (!chunkRenderer.skyLit || chunkRenderer.dirty) continue;
                this.dirtyChunks.add(chunkRenderer);
                chunkRenderer.setDirty();
            }
        }
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, TileEntity tileEntity) {
    }

    @Override
    public void levelEvent(@Nullable Player player, int id, int x, int y, int z, int data) {
        Random random = this.world.rand;
        switch (id) {
            case 1001: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "tile.dispenser.click", 1.0f, 1.0f);
                break;
            }
            case 1000: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "tile.dispenser.eject", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "tile.dispenser.fire", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                Direction direction = Direction.getDirectionById(data);
                int xOff = direction.getOffsetX();
                int yOff = direction.getOffsetY();
                int zOff = direction.getOffsetZ();
                double px = (double)x + (double)xOff * 0.6 + 0.5;
                double py = (double)y + (double)yOff * 0.6 + 0.5;
                double pz = (double)z + (double)zOff * 0.6 + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double rO = random.nextDouble() * 0.2 + 0.01;
                    double fx = px + (double)xOff * 0.01 + (random.nextDouble() - 0.5) * (double)zOff * 0.5;
                    double fy = py + (double)yOff * 0.01 + (random.nextDouble() - 0.5) * (double)yOff * 0.5;
                    double fz = pz + (double)zOff * 0.01 + (random.nextDouble() - 0.5) * (double)xOff * 0.5;
                    double mx = (double)xOff * rO + random.nextGaussian() * 0.01;
                    double my = (double)yOff * rO + random.nextGaussian() * 0.01;
                    double mz = (double)zOff * rO + random.nextGaussian() * 0.01;
                    this.addParticle("smoke", fx, fy, fz, mx, my, mz, 0);
                }
                break;
            }
            case 2001: {
                if (data > 0) {
                    Block<?> block = Blocks.blocksList[data];
                    this.world.playBlockSoundEffect(null, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, EnumBlockSoundEffectType.MINE);
                }
                this.mc.particleEngine.destroy(x, y, z, data, this.world.getBlockMetadata(x, y, z));
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_open", 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_close", 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                Item item = Item.itemsList[data];
                if (item instanceof ItemDiscMusic) {
                    ItemDiscMusic record = (ItemDiscMusic)item;
                    this.world.playRecord(record.recordName, record.recordAuthor, x, y, z);
                    break;
                }
                this.world.playRecord(null, null, x, y, z);
                break;
            }
            case 1006: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, this.world.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
            case 1007: {
                this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, this.world.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
        }
    }

    @Override
    public void entityAdded(Entity entity) {
    }

    @Override
    public void entityRemoved(Entity entity) {
    }

    static {
        for (int i = 0; i < breakingAnimation.length; ++i) {
            RenderGlobal.breakingAnimation[i] = TextureRegistry.getTexture("minecraft:block/breaking/" + i);
        }
    }
}

