/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFenceGate;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.useless.dragonfly.DisplayPos;

public class BlockModelFenceGate<T extends BlockLogicFenceGate>
extends BlockModelStandard<T> {
    protected static final DisplayPos FENCE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 135.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos FENCE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 90.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public BlockModelFenceGate(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", FENCE_GUI);
        this.setDisplayPos("head", FENCE_HEAD);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        AABBd bounds = new AABBd(this.block.getBounds());
        boolean flag = true;
        int meta = worldSource.getBlockData(tilePos);
        boolean isOpen = BlockLogicFenceGate.isOpen(meta);
        int direction = BlockLogicFenceGate.getDirection(meta);
        if (direction == 3 || direction == 1) {
            float f = 0.4375f;
            float f4 = 0.5625f;
            float f8 = 0.0f;
            float f12 = 0.125f;
            bounds.setMin(f, 0.3125, f8).setMax(f4, 1.0, f12);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            f8 = 0.875f;
            f12 = 1.0f;
            bounds.setMin(f, 0.3125, f8).setMax(f4, 1.0, f12);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else {
            float f1 = 0.0f;
            float f5 = 0.125f;
            float f9 = 0.4375f;
            float f13 = 0.5625f;
            bounds.setMin(f1, 0.3125, f9).setMax(f5, 1.0, f13);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            f1 = 0.875f;
            f5 = 1.0f;
            bounds.setMin(f1, 0.3125, f9).setMax(f5, 1.0, f13);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        if (!isOpen) {
            if (direction == 3 || direction == 1) {
                float f2 = 0.4375f;
                float f6 = 0.5625f;
                float f10 = 0.375f;
                float f14 = 0.5f;
                bounds.setMin(f2, 0.375, f10).setMax(f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                f10 = 0.5f;
                f14 = 0.625f;
                bounds.setMin(f2, 0.375, f10).setMax(f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                f10 = 0.625f;
                f14 = 0.875f;
                bounds.setMin(f2, 0.375, f10).setMax(f6, 0.5625, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                bounds.setMin(f2, 0.75, f10).setMax(f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                f10 = 0.125f;
                f14 = 0.375f;
                bounds.setMin(f2, 0.375, f10).setMax(f6, 0.5625, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                bounds.setMin(f2, 0.75, f10).setMax(f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            } else {
                float f3 = 0.375f;
                float f7 = 0.5f;
                float f11 = 0.4375f;
                float f15 = 0.5625f;
                bounds.setMin(f3, 0.375, f11).setMax(f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                f3 = 0.5f;
                f7 = 0.625f;
                bounds.setMin(f3, 0.375, f11).setMax(f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                f3 = 0.625f;
                f7 = 0.875f;
                bounds.setMin(f3, 0.375, f11).setMax(f7, 0.5625, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                bounds.setMin(f3, 0.75, f11).setMax(f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                f3 = 0.125f;
                f7 = 0.375f;
                bounds.setMin(f3, 0.375, f11).setMax(f7, 0.5625, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
                bounds.setMin(f3, 0.75, f11).setMax(f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            }
        } else if (direction == 3) {
            bounds.setMin(0.8125, 0.375, 0.0).setMax(0.9375, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.8125, 0.375, 0.875).setMax(0.9375, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.5625, 0.375, 0.0).setMax(0.8125, 0.5625, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.5625, 0.375, 0.875).setMax(0.8125, 0.5625, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.5625, 0.75, 0.0).setMax(0.8125, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.5625, 0.75, 0.875).setMax(0.8125, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else if (direction == 1) {
            bounds.setMin(0.0625, 0.375, 0.0).setMax(0.1875, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0625, 0.375, 0.875).setMax(0.1875, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.1875, 0.375, 0.0).setMax(0.4375, 0.5625, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.1875, 0.375, 0.875).setMax(0.4375, 0.5625, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.1875, 0.75, 0.0).setMax(0.4375, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.1875, 0.75, 0.875).setMax(0.4375, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else if (direction == 0) {
            bounds.setMin(0.0, 0.375, 0.8125).setMax(0.125, 0.9375, 0.9375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.875, 0.375, 0.8125).setMax(1.0, 0.9375, 0.9375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0, 0.375, 0.5625).setMax(0.125, 0.5625, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.875, 0.375, 0.5625).setMax(1.0, 0.5625, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0, 0.75, 0.5625).setMax(0.125, 0.9375, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.875, 0.75, 0.5625).setMax(1.0, 0.9375, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else if (direction == 2) {
            bounds.setMin(0.0, 0.375, 0.0625).setMax(0.125, 0.9375, 0.1875);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.875, 0.375, 0.0625).setMax(1.0, 0.9375, 0.1875);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0, 0.375, 0.1875).setMax(0.125, 0.5625, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.875, 0.375, 0.1875).setMax(1.0, 0.5625, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0, 0.75, 0.1875).setMax(0.125, 0.9375, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.875, 0.75, 0.1875).setMax(1.0, 0.9375, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        return flag;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(this.getStandaloneTintColor(metadata));
        for (int bar = 0; bar < 3; ++bar) {
            float f6 = 0.0625f;
            AABBd bounds = new AABBd(this.block.getBounds());
            switch (bar) {
                case 0: {
                    bounds.setMin(0.5f - f6, 0.3f, 0.0).setMax(0.5f + f6, 1.0, f6 * 2.0f);
                    break;
                }
                case 1: {
                    bounds.setMin(0.5f - f6, 0.3f, 1.0f - f6 * 2.0f).setMax(0.5f + f6, 1.0, 1.0);
                    break;
                }
                default: {
                    bounds.setMin(0.5f - f6, 0.5, 0.0).setMax(0.5f + f6, 1.0f - f6, 1.0);
                }
            }
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        }
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }
}

