/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texturepack.TexturePackException;
import net.minecraft.core.util.helper.MathHelper;

public class DynamicTextureFireflyJar
extends DynamicTexture {
    private final byte[] originalData;
    private long ticks = 0L;
    final float minR = 0.3764706f;
    final float minG = 0.21176471f;
    final float minB = 0.0f;

    public DynamicTextureFireflyJar(IconCoordinate texture) {
        super(texture);
        BufferedImage image = texture.getImageStorage();
        if (image == null) {
            throw new TexturePackException("Could not load image from texture'" + String.valueOf(texture.namespaceId) + "'!");
        }
        texture.setDimension(image.getWidth(), image.getHeight());
        this.originalData = new byte[texture.getArea() * 4];
        for (int x = 0; x < texture.width; ++x) {
            for (int y = 0; y < texture.height; ++y) {
                DynamicTextureFireflyJar.putPixel(this.originalData, y * texture.width + x, image.getRGB(x, y));
            }
        }
    }

    @Override
    public void postInit() {
        this.initTexture();
    }

    private float getInternalBrightness() {
        float b = ((float)Math.sin((float)this.ticks / 10.0f) + 1.0f) / 2.0f;
        return MathHelper.clamp(b, 0.0f, 1.0f);
    }

    @Override
    public void update() {
        ++this.ticks;
        float br = this.getInternalBrightness();
        for (int x = 0; x < this.targetTexture.width; ++x) {
            for (int y = 0; y < this.targetTexture.height; ++y) {
                int i = y * this.targetTexture.width + x;
                int a = this.originalData[i * 4 + 3] & 0xFF;
                int r = this.originalData[i * 4 + 0] & 0xFF;
                int g = this.originalData[i * 4 + 1] & 0xFF;
                int b = this.originalData[i * 4 + 2] & 0xFF;
                if ((float)x >= (float)this.targetTexture.width * 0.375f && (float)x < (float)this.targetTexture.width * 0.625f && (float)y >= (float)this.targetTexture.height * 0.375f && y < this.targetTexture.height) {
                    float rf = (float)r / 255.0f;
                    float gf = (float)g / 255.0f;
                    float bf = (float)b / 255.0f;
                    float maxR = MathHelper.clamp(rf + 0.1f, 0.0f, 1.0f);
                    float maxG = MathHelper.clamp(gf + 0.1f, 0.0f, 1.0f);
                    float maxB = MathHelper.clamp(bf + 0.1f, 0.0f, 1.0f);
                    float tMinR = MathHelper.lerp(0.3764706f, rf, 0.85f);
                    float tMinG = MathHelper.lerp(0.21176471f, gf, 0.85f);
                    float tMinB = MathHelper.lerp(0.0f, bf, 0.85f);
                    if (br < 0.5f) {
                        rf = MathHelper.lerp(tMinR, rf, br * 2.0f);
                        gf = MathHelper.lerp(tMinG, gf, br * 2.0f);
                        bf = MathHelper.lerp(tMinB, bf, br * 2.0f);
                    } else {
                        rf = MathHelper.lerp(rf, maxR, (br - 0.5f) * 2.0f);
                        gf = MathHelper.lerp(gf, maxG, (br - 0.5f) * 2.0f);
                        bf = MathHelper.lerp(bf, maxB, (br - 0.5f) * 2.0f);
                    }
                    r = (int)(rf * 255.0f);
                    g = (int)(gf * 255.0f);
                    b = (int)(bf * 255.0f);
                }
                this.imageData[i * 4 + 0] = (byte)r;
                this.imageData[i * 4 + 1] = (byte)g;
                this.imageData[i * 4 + 2] = (byte)b;
                this.imageData[i * 4 + 3] = (byte)a;
            }
        }
    }
}

