/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.mojang.logging.CategorizedLogger;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.terrain.VertexData;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL41;

public class VertexBuffer {
    public static final CategorizedLogger LOGGER = LogUtils.getLogger();
    private int vbo;
    private final int vao;
    private long capacity;
    public List<Entry> entries = new ArrayList<Entry>();
    private int entryHashCounter;

    public VertexBuffer(long initialCapacity) {
        this.capacity = initialCapacity;
        this.vbo = GL15.glGenBuffers();
        this.vao = GL41.glGenVertexArrays();
        GL15.glBindBuffer(34962, this.vbo);
        GL15.glBufferData(34962, this.capacity, 35044);
        GL15.glBindBuffer(34962, 0);
    }

    public Entry addVertexData(VertexData vertexData) {
        if (vertexData.vertexCount <= 0) {
            return null;
        }
        if (this.entries.isEmpty()) {
            return this.insertAtIndex(vertexData, 0);
        }
        int bytes = vertexData.buffer.position();
        if (this.entries.size() == 1) {
            Entry entry = this.entries.get(0);
            if (entry.position > bytes) {
                return this.insertAtIndex(vertexData, 0);
            }
            return this.insertAtIndex(vertexData, 1);
        }
        for (int i = 0; i < this.entries.size() - 1; ++i) {
            Entry entry = this.entries.get(i);
            Entry nextEntry = this.entries.get(i + 1);
            int availableSpace = nextEntry.position - (entry.position + entry.size);
            if (availableSpace <= bytes) continue;
            return this.insertAtIndex(vertexData, i + 1);
        }
        return this.insertAtIndex(vertexData, this.entries.size());
    }

    private Entry insertAtIndex(VertexData vertexData, int listIndex) {
        int pos = 0;
        int bytes = vertexData.buffer.position();
        if (listIndex > 0) {
            Entry prev = this.entries.get(listIndex - 1);
            pos = prev.position + prev.size;
        }
        if ((long)(pos + bytes) >= this.capacity) {
            this.expandVBO();
        }
        Entry entry = new Entry(pos, bytes);
        if (listIndex > 0) {
            Entry previousEntry = this.entries.get(listIndex - 1);
            if (previousEntry.position + previousEntry.size > pos) {
                throw new RuntimeException("Entry collision: " + String.valueOf(entry) + " and " + String.valueOf(previousEntry));
            }
        }
        if (listIndex < this.entries.size() - 1) {
            Entry nextEntry = this.entries.get(listIndex + 1);
            if (nextEntry.position <= pos + bytes) {
                throw new RuntimeException("Entry collision: " + String.valueOf(entry) + " and " + String.valueOf(nextEntry));
            }
        }
        vertexData.buffer.flip();
        GL15.glBindBuffer(34962, this.vbo);
        GL15.glBufferSubData(34962, (long)pos, vertexData.buffer);
        GL15.glBindBuffer(34962, 0);
        this.entries.add(listIndex, entry);
        return entry;
    }

    private void expandVBO() {
        long prevCapacity = this.capacity;
        long newCapacity = this.capacity * 2L;
        if (newCapacity < this.capacity) {
            throw new RuntimeException();
        }
        LOGGER.warn("Expand VBO Buffer: " + newCapacity);
        OpenGLHelper.checkError("pre expand buffer");
        int newBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, newBuffer);
        GL15.glBufferData(34962, newCapacity, 35044);
        OpenGLHelper.checkError("create expand buffer");
        GL15.glBindBuffer(36662, this.vbo);
        GL15.glBindBuffer(36663, newBuffer);
        GL31.glCopyBufferSubData(36662, 36663, 0L, 0L, this.capacity);
        GL15.glBindBuffer(36662, 0);
        GL15.glBindBuffer(36663, 0);
        OpenGLHelper.checkError("copy buffer");
        this.capacity = newCapacity;
        this.vbo = newBuffer;
    }

    public boolean removeEntry(Entry entry) {
        return this.entries.remove(entry);
    }

    public int getVbo() {
        return this.vbo;
    }

    public int getVao() {
        return this.vao;
    }

    public int entryCount() {
        return this.entries.size();
    }

    public class Entry {
        public final int position;
        public final int size;
        private final int hashCode;

        public Entry(int position, int size) {
            this.hashCode = VertexBuffer.this.entryHashCounter++;
            this.position = position;
            this.size = size;
        }

        public String toString() {
            return "VertexBufferEntry[position: " + this.position + ", size: " + this.size + "]";
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

