/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.customatlas.CustomAtlasHandler;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AtlasStitcher
extends Texture {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String rootAssetPath = "/assets";
    @NotNull
    public Map<NamespaceID, IconCoordinate> textureMap = new Object2ObjectOpenHashMap<NamespaceID, IconCoordinate>();
    @NotNull
    public Map<String, String> idDirMap = new Object2ObjectOpenHashMap<String, String>();
    @Nullable
    public final BufferedImage defaultTexture;
    public BufferedImage atlas;
    private int atlasWidth;
    private int atlasHeight;
    private double invWidth;
    private double invHeight;
    private final boolean mipmap;
    private final boolean tickPaused;

    public AtlasStitcher(boolean tickWhenPaused, boolean mipmap, @Nullable BufferedImage defaultTexture) {
        this.tickPaused = tickWhenPaused;
        this.mipmap = mipmap;
        this.defaultTexture = defaultTexture;
    }

    @NotNull
    public AtlasStitcher addDirectory(@NotNull String id, @NotNull String path) {
        this.idDirMap.put(id, path);
        return this;
    }

    @NotNull
    protected IconCoordinate getTexture(@NotNull NamespaceID id) {
        IconCoordinate cached = this.textureMap.get(id);
        if (cached != null) {
            return cached;
        }
        IconCoordinate iconCoordinate = new IconCoordinate(this, id, this.getSourceImagePath(id));
        this.textureMap.put(id, iconCoordinate);
        return iconCoordinate;
    }

    @NotNull
    public String getSourceImagePath(@NotNull NamespaceID id) {
        String value = id.value();
        int slashIndex = value.indexOf("/");
        if (slashIndex != -1) {
            String dir = this.idDirMap.get(value.substring(0, slashIndex));
            return String.format("%s/%s/%s/%s.png", rootAssetPath, id.namespace(), dir, value.substring(slashIndex + 1));
        }
        throw new IllegalArgumentException("Id " + String.valueOf(id) + " does not specify an id!");
    }

    public void initializeAll(@NotNull String namespace, boolean searchSubDirectories) throws IOException, URISyntaxException {
        for (Map.Entry<String, String> e : this.idDirMap.entrySet()) {
            String[] paths;
            String folder = String.format("%s/%s/%s/", rootAssetPath, namespace, e.getValue());
            for (String p : paths = TextureRegistry.getFilesAndSubFiles(folder, searchSubDirectories)) {
                this.getTexture(new NamespaceID(namespace, e.getKey() + "/" + p.replace(".png", "")));
            }
        }
    }

    public void preinit() {
        this.generate();
        long startTime = System.nanoTime();
        Minecraft mc = Minecraft.getMinecraft();
        ArrayList<IconCoordinate> coordinateList = new ArrayList<IconCoordinate>(this.textureMap.values());
        ArrayList<Future<IconCoordinate>> futures = new ArrayList<Future<IconCoordinate>>();
        ExecutorService service = Executors.newFixedThreadPool(32);
        for (IconCoordinate iconCoordinate : coordinateList) {
            futures.add(service.submit(new SetupTexture(mc.texturePackList, iconCoordinate, this.defaultTexture)));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("", e);
            }
        }
        service.shutdown();
        LOGGER.debug("Took '{}' seconds to load images.", (Object)((double)(System.nanoTime() - startTime) / 1.0E9));
    }

    @Override
    public void init() {
        int area = 0;
        int maxWidth = 0;
        ArrayList<IconCoordinate> coordinateList = new ArrayList<IconCoordinate>(this.textureMap.values());
        for (IconCoordinate coordinate : coordinateList) {
            if (coordinate.needsDimensions()) {
                BufferedImage image = coordinate.getImageStorage();
                coordinate.setDimension(image.getWidth(), image.getHeight());
            }
            area += coordinate.getArea();
            if (coordinate.width <= maxWidth) continue;
            maxWidth = coordinate.width;
        }
        int targetWidth = Integer.highestOneBit((int)Math.max(Math.ceil(Math.sqrt(area)), (double)maxWidth)) << 1;
        Collections.sort(coordinateList);
        int nextX = 0;
        int currentY = 0;
        int nextY = ((IconCoordinate)coordinateList.get((int)0)).height;
        int maxRealWidth = 0;
        for (IconCoordinate coordinate : coordinateList) {
            if (nextX + coordinate.width > targetWidth) {
                nextX = 0;
                currentY = nextY;
                nextY += coordinate.height;
            }
            coordinate.setPosition(nextX, currentY);
            if ((nextX += coordinate.width) <= maxRealWidth) continue;
            maxRealWidth = nextX;
        }
        BufferedImage generatedAtlas = new BufferedImage(targetWidth, Integer.highestOneBit(nextY) << 1, 2);
        this.atlasWidth = generatedAtlas.getWidth();
        this.atlasHeight = generatedAtlas.getHeight();
        this.invWidth = 1.0 / (double)this.atlasWidth;
        this.invHeight = 1.0 / (double)this.atlasHeight;
        Graphics2D atlas = generatedAtlas.createGraphics();
        atlas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (IconCoordinate coordinate : coordinateList) {
            coordinate.drawToAtlas(atlas);
            coordinate.discardImage();
        }
        atlas.dispose();
        this.setupTexture(generatedAtlas, false, false, this.mipmap);
        this.atlas = generatedAtlas;
    }

    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    public double getInverseWidth() {
        return this.invWidth;
    }

    public double getInverseHeight() {
        return this.invHeight;
    }

    public boolean tickWhenPaused() {
        return this.tickPaused;
    }

    public boolean hasMipmaps() {
        return this.mipmap;
    }

    public static class SetupTexture
    implements Callable<IconCoordinate> {
        @NotNull
        private final TexturePackList packList;
        @NotNull
        private final IconCoordinate coordinate;
        @Nullable
        private final BufferedImage defaultTexture;

        public SetupTexture(@NotNull TexturePackList packList, @NotNull IconCoordinate coordinate, @Nullable BufferedImage defaultTexture) {
            this.packList = packList;
            this.coordinate = coordinate;
            this.defaultTexture = defaultTexture;
        }

        @Override
        public IconCoordinate call() {
            TexturePack pack;
            this.coordinate.resetMetadata();
            BufferedImage image = CustomAtlasHandler.getTextureOverride(this.packList, this.coordinate.sourceImagePath);
            if (image == null && (pack = this.packList.getHighestPriorityTexturePackWithFile(this.coordinate.sourceImagePath)) != null) {
                String metaPath;
                for (int attempt = 0; attempt < 3; ++attempt) {
                    try {
                        image = Textures.readImageUnhandled(pack.getResourceAsStream(this.coordinate.sourceImagePath));
                        if (image == null) continue;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                }
                if (pack.hasFile(metaPath = this.coordinate.sourceImagePath + ".mcmeta")) {
                    try (InputStream stream = pack.getResourceAsStream(metaPath);){
                        this.coordinate.initMetadata(stream);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to initiate metadata for '{}'!", (Object)this.coordinate.namespaceId, (Object)e);
                    }
                }
            }
            if (image == null || image == Textures.missingTexture) {
                LOGGER.warn("{} could not be found!", (Object)this.coordinate.sourceImagePath);
                if (this.defaultTexture != null) {
                    image = this.defaultTexture;
                }
                if (image == null) {
                    image = Textures.missingTexture;
                }
            }
            this.coordinate.setImage(image);
            return this.coordinate;
        }
    }
}

