/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.render.texture.TextureBuffered;
import net.minecraft.client.render.texturepack.Manifest;
import net.minecraft.client.render.texturepack.ManifestFallback;
import net.minecraft.client.render.texturepack.TexturePack;
import org.slf4j.Logger;

public class TexturePackCustom
extends TexturePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private TextureBuffered thumbnailImage = null;
    private BufferedImage thumbnailBuffer;
    public final File file;
    private ZipFile zipFile;
    public boolean debug = false;

    public TexturePackCustom(File file) {
        this.fileName = file.getName();
        this.file = file;
    }

    public void setDebug() {
        this.debug = true;
    }

    @Override
    public void readTexturePackManifest() throws IOException {
        if (this.file.isFile()) {
            ZipEntry manifestEntry = this.zipFile.getEntry("manifest.json");
            if (manifestEntry != null) {
                try {
                    in = this.zipFile.getInputStream(manifestEntry);
                    try {
                        this.readManifest(in);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception reading manifest for '{}'!", (Object)this.packId, (Object)e);
                }
            } else {
                name = this.file.getName();
                line1 = "";
                String line2 = "";
                ZipEntry packTxtEntry = this.zipFile.getEntry("pack.txt");
                if (packTxtEntry != null) {
                    try (InputStream in = this.zipFile.getInputStream(packTxtEntry);
                         BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                        line1 = br.readLine();
                        line2 = br.readLine();
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception reading pack.txt for '{}'!", (Object)this.packId, (Object)e);
                    }
                }
                this.manifest = new ManifestFallback(name, line1, line2, 0);
            }
        } else if (this.file.isDirectory()) {
            File manifestFile = new File(this.file, "manifest.json");
            if (manifestFile.exists()) {
                try {
                    in = Files.newInputStream(manifestFile.toPath(), new OpenOption[0]);
                    try {
                        this.readManifest(in);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception reading manifest for '{}'!", (Object)this.packId, (Object)e);
                }
            } else {
                name = this.file.getName();
                line1 = "";
                String line2 = "";
                File packTxtFile = new File(this.file, "pack.txt");
                if (packTxtFile.exists()) {
                    try (InputStream in = Files.newInputStream(packTxtFile.toPath(), new OpenOption[0]);
                         BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                        line1 = br.readLine();
                        line2 = br.readLine();
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception reading pack.txt for '{}'!", (Object)this.packId, (Object)e);
                    }
                }
                this.manifest = new ManifestFallback(name, line1, line2, 0);
            }
        }
        try (InputStream inputstream = this.getResourceAsStream("pack.png");){
            this.thumbnailBuffer = ImageIO.read(inputstream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readManifest(InputStream in) {
        try {
            this.manifest = new Manifest(this.file, in);
        }
        catch (Manifest.ManifestException e) {
            this.manifest = new ManifestFallback(this.fileName, "Manifest Error: " + e.getMessage(), "", -1);
            LOGGER.error("Manifest Error!", e);
        }
        catch (Exception e) {
            this.manifest = new ManifestFallback(this.fileName, "Manifest Error", "", -1);
            LOGGER.error("Manifest Error!", e);
        }
    }

    @Override
    public void disposeOfTexturePack(Minecraft minecraft) {
        if (this.thumbnailBuffer != null) {
            this.thumbnailImage.delete();
            this.thumbnailImage = null;
        }
        this.closeTexturePackFile();
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.thumbnailBuffer != null && this.thumbnailImage == null) {
            this.thumbnailImage = minecraft.textureManager.loadBufferedTexture(this.thumbnailBuffer);
        }
        if (this.thumbnailBuffer != null) {
            minecraft.textureManager.bindTexture(this.thumbnailImage);
        } else {
            minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/unknown_pack.png").bind();
        }
    }

    @Override
    public void readZipFile() {
        try {
            this.zipFile = new ZipFile(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeTexturePackFile() {
        try {
            this.zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zipFile = null;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.getResourceAsStream(path, true);
    }

    private InputStream getResourceAsStream(String path, boolean firstCall) {
        block11: {
            if (firstCall && Holidays.getCurrentThemedHoliday() != null && ((Boolean)Minecraft.getMinecraft().gameSettings.enableHolidayTextures.value).booleanValue()) {
                assert (Holidays.getCurrentThemedHoliday().getCustomResourcesSubPath() != null) : "Current themed holiday must have a theme!";
                String holidayPath = ("/holidays/" + Holidays.getCurrentThemedHoliday().getCustomResourcesSubPath() + "/" + path).replace("//", "/");
                InputStream holidayStream = this.getResourceAsStream(holidayPath, false);
                if (holidayStream != null) {
                    return holidayStream;
                }
            }
            if (this.file.isFile()) {
                String zipEntryPath = path;
                if (path.startsWith("/")) {
                    zipEntryPath = path.substring(1);
                }
                try {
                    ZipEntry zipentry = this.zipFile.getEntry(zipEntryPath);
                    if (zipentry != null) {
                        return this.zipFile.getInputStream(zipentry);
                    }
                    break block11;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            try {
                File file = new File(this.file, path);
                if (file.exists()) {
                    return Files.newInputStream(file.toPath(), new OpenOption[0]);
                }
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected String[] getFilesInDirectory(String directory) {
        if (!((String)directory).endsWith("/")) {
            directory = (String)directory + "/";
        }
        if (this.file.isFile()) {
            ZipEntry dirEntry = this.zipFile.getEntry((String)directory);
            if (dirEntry != null) {
                if (dirEntry.isDirectory()) {
                    ArrayList<String> files = new ArrayList<String>();
                    Enumeration<? extends ZipEntry> e = this.zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (!entry.getName().startsWith((String)directory)) continue;
                        files.add(entry.getName());
                    }
                    return files.toArray(new String[0]);
                }
                return new String[]{directory};
            }
            return super.getFilesInDirectory((String)directory);
        }
        File file = new File(this.file, (String)directory);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    String[] fileStrings = new String[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        fileStrings[i] = (String)directory + files[i].getName();
                    }
                    return fileStrings;
                }
                return new String[0];
            }
            return new String[]{directory};
        }
        return super.getFilesInDirectory((String)directory);
    }

    @Override
    public boolean hasFile(String file) {
        if (this.file.isFile()) {
            boolean h = false;
            try (ZipFile zipfile = new ZipFile(this.file);){
                h = zipfile.getEntry(file.substring(1)) != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return h;
        }
        return new File(this.file, file).exists();
    }
}

