/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicGrass
extends BlockLogic {
    @NotNull
    public final Block<?> dirt;

    public BlockLogicGrass(@NotNull Block<?> block, @NotNull Block<?> dirt) {
        super(block, Materials.GRASS);
        block.setTicking(true);
        this.dirt = dirt;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        TilePos queryPos = new TilePos();
        if (world.getBlockLightValue(tilePos.up(queryPos)) < 4 && Blocks.lightBlock[world.getBlockId(tilePos.up(queryPos))] > 2) {
            world.setBlockIdNotify(tilePos, this.dirt.id());
        } else if (world.getBlockLightValue(tilePos.up(queryPos)) >= 9) {
            for (int i = 0; i < 4; ++i) {
                int checkZ;
                int checkY;
                int checkX = tilePos.x() + rand.nextInt(3) - 1;
                if (world.getBlockId(queryPos.set(checkX, checkY = tilePos.y() + rand.nextInt(5) - 3, checkZ = tilePos.x() + rand.nextInt(3) - 1)) != this.dirt.id() || world.getBlockLightValue(queryPos.set(checkX, checkY + 1, checkZ)) < 4 || Blocks.lightBlock[world.getBlockId(queryPos.set(checkX, checkY + 1, checkZ))] > 2) continue;
                world.setBlockIdNotify(queryPos.set(checkX, checkY, checkZ), this.block.id());
            }
            if (world.getGameRuleValue(GameRules.DO_SEASONAL_GROWTH).booleanValue() && world.getBlockId(tilePos.up(queryPos)) == 0 && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().growFlowers && rand.nextInt(256) == 0) {
                int idToSpawn = 0;
                int r = rand.nextInt(400);
                if (r < 26) {
                    idToSpawn = Blocks.FLOWER_RED.id();
                } else if (r < 41) {
                    idToSpawn = Blocks.FLOWER_YELLOW.id();
                } else if (r < 60) {
                    Biome biome = world.getBlockBiome(tilePos.up(queryPos));
                    if (biome == Biomes.OVERWORLD_BIRCH_FOREST || biome == Biomes.OVERWORLD_SEASONAL_FOREST) {
                        idToSpawn = Blocks.FLOWER_PINK.id();
                    } else if (biome == Biomes.OVERWORLD_MEADOW || biome == Biomes.OVERWORLD_BOREAL_FOREST || biome == Biomes.OVERWORLD_SHRUBLAND) {
                        idToSpawn = Blocks.FLOWER_PURPLE.id();
                    } else if (biome == Biomes.OVERWORLD_FOREST || biome == Biomes.OVERWORLD_SWAMPLAND || biome == Biomes.OVERWORLD_RAINFOREST || biome == Biomes.OVERWORLD_CAATINGA) {
                        idToSpawn = Blocks.FLOWER_LIGHT_BLUE.id();
                    }
                } else {
                    idToSpawn = rand.nextInt(8) == 0 ? Blocks.TALLGRASS_FERN.id() : Blocks.TALLGRASS.id();
                }
                world.setBlockIdNotify(tilePos.up(queryPos), idToSpawn);
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this);
                break;
            }
            default: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this.dirt);
            }
        }
        return itemStackArray;
    }
}

