/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlock<T extends BlockLogic>
extends Item {
    @NotNull
    protected Block<T> block;

    public ItemBlock(@NotNull Block<T> block) {
        super(block.namespaceId(), block.getKey(), block.id());
        this.block = Objects.requireNonNull(block);
    }

    @NotNull
    public Block<T> getBlock() {
        return this.block;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (selfStack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        if (blockPos.y() < 0 || blockPos.y() >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockIdBePlacedAt(this.block.id(), blockPos, false, side) && selfStack.consumeItem(player)) {
            int meta = this.getPlacedData(selfStack, world, player, blockPos, side, xHit, yHit);
            if (world.setBlockIdDataNotify(blockPos, this.block.id(), meta)) {
                TileEntity tileEntity;
                if (player == null) {
                    this.block.onPlacedOnSide(world, blockPos, side, xHit, yHit);
                } else {
                    this.block.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
                }
                if (this.block.isEntityTile && selfStack.getData().containsKey("tileEntityData") && (tileEntity = world.getTileEntity(blockPos)) != null) {
                    tileEntity.readAdditionalData(selfStack.getData().getCompound("tileEntityData"));
                }
                world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                return true;
            }
            if (player == null || player.getGamemode().consumeBlocks()) {
                ++selfStack.stackSize;
            }
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        Block<?> b = world.getBlock(blockPos = blockPos.add(direction, new TilePos()));
        if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo(b)) {
            this.onUseOnBlock(selfStack, world, null, blockPos, direction.getSide(), 0.5, 0.5);
        }
    }

    public int getPlacedData(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        return this.block.getPlacedData(player, selfStack, world, blockPos, side, xHit, yHit);
    }

    @Override
    @NotNull
    public String getLanguageKey(@NotNull ItemStack selfStack) {
        return this.block.getLanguageKey(selfStack.getMetadata());
    }

    @Override
    @NotNull
    public String getKey() {
        return this.block.getKey();
    }
}

