/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.LargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.noise.PerlinNoise;
import net.minecraft.core.world.noise.WorleyNoise;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public class IceFloeLargeFeature
extends LargeFeature {
    @Nullable
    private PerlinNoise perlinNoise = null;
    @Nullable
    private PerlinNoise scalePerlinNoise = null;
    @Nullable
    private World lastWorld = null;

    @Override
    protected void doGeneration(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result) {
        if (this.perlinNoise == null || this.scalePerlinNoise == null || this.lastWorld != world) {
            this.perlinNoise = new PerlinNoise(world.getRandomSeed(), 4);
            this.scalePerlinNoise = new PerlinNoise(world.getRandomSeed(), 2);
            this.lastWorld = world;
        }
        @NotNull WorldType worldType = world.getWorldType();
        int oceanY = worldType.getMinY() + worldType.getOceanY();
        @NotNull TilePos tilePos = new TilePos();
        @NotNull Vector2f vec = new Vector2f();
        @NotNull WorleyNoise.Result worley = new WorleyNoise.Result();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                tilePos.set(16 * baseChunkX + x, oceanY, 16 * baseChunkZ + z);
                @NotNull Biome biome = world.getBlockBiome(tilePos);
                if (biome != Biomes.OVERWORLD_GLACIER) continue;
                float worleyScaleScale = 50.0f;
                float worleyScale = 0.875f + (float)this.scalePerlinNoise.getNormalized((float)(baseChunkX * 16 + x) / 50.0f, (float)(baseChunkZ * 16 + z) / 50.0f) * 0.25f;
                vec.x = ((float)baseChunkX + (float)x / 16.0f) * worleyScale;
                vec.y = ((float)baseChunkZ + (float)z / 16.0f) * worleyScale;
                WorleyNoise.getWorleyDistance2d(vec, worley);
                float lineScale = 10.0f;
                float lineWidth = (float)(this.perlinNoise.get((float)(baseChunkX * 16 + x) / 10.0f, (float)(baseChunkZ * 16 + z) / 10.0f) / 2.0 + 0.5);
                if (MathHelper.unsignedMod(worley.index, 15.0) == 0.0 || worley.distance > 0.9f + lineWidth * 0.05f) continue;
                for (y = oceanY - 3; y < oceanY; ++y) {
                    this.trySetBlock(result, x, y, z, Blocks.PERMAICE.id());
                }
                for (y = oceanY; y < oceanY + 1; ++y) {
                    this.trySetBlock(result, x, y, z, Blocks.BLOCK_SNOW.id());
                }
            }
        }
    }

    private void trySetBlock(@NotNull ChunkGeneratorResult result, int x, int y, int z, int id) {
        int current = result.getBlock(x, y, z);
        if (current == Blocks.FLUID_WATER_STILL.id() || current == 0) {
            result.setBlock(x, y, z, id);
        }
    }

    @Override
    public int getRadiusChunk() {
        return 0;
    }
}

