/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.noise.BaseImprovedNoise;
import net.minecraft.core.world.noise.SurfaceNoise;

public abstract class BasePerlinNoise<T extends BaseImprovedNoise>
extends SurfaceNoise {
    private static final double MAX_2D = Math.sqrt(0.5);
    private final T[] octaves;
    private final int numOctaves;
    final double maxValue;

    public BasePerlinNoise(long seed, int numOctaves) {
        this(seed, numOctaves, 0);
    }

    public BasePerlinNoise(long seed, int numOctaves, int preOctaves) {
        Random random = new Random(seed);
        for (int i = 0; i < preOctaves; ++i) {
            random.nextDouble();
            random.nextDouble();
            random.nextDouble();
            for (int j = 0; j < 256; ++j) {
                random.nextInt(256 - j);
            }
        }
        this.numOctaves = numOctaves;
        this.octaves = this.newOctaves(random, numOctaves);
        double maxValue = 0.0;
        double levelScale = 1.0;
        for (int i = 0; i < this.numOctaves; ++i) {
            maxValue += MAX_2D / levelScale;
            levelScale /= 2.0;
        }
        this.maxValue = maxValue;
    }

    protected abstract T[] newOctaves(Random var1, int var2);

    public double get(double x, double y) {
        double out = 0.0;
        double levelScale = 1.0;
        for (int i = 0; i < this.numOctaves; ++i) {
            out += ((BaseImprovedNoise)this.octaves[i]).getValue(x * levelScale, y * levelScale) / levelScale;
            levelScale /= 2.0;
        }
        return out;
    }

    public double getNormalized(double x, double y) {
        double value = this.get(x, y);
        double workingValue = value / this.maxValue;
        workingValue = 0.5 + workingValue / 2.0;
        return workingValue;
    }

    public double[] get(double[] noiseArray, double x, double y, double z, int xSize, int ySize, int zSize, double scaleX, double scaleY, double scaleZ) {
        if (noiseArray == null) {
            noiseArray = new double[xSize * ySize * zSize];
        } else {
            Arrays.fill(noiseArray, 0.0);
        }
        double frequency = 1.0;
        for (int i = 0; i < this.numOctaves; ++i) {
            ((BaseImprovedNoise)this.octaves[i]).add(noiseArray, x, y, z, xSize, ySize, zSize, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noiseArray;
    }

    public double[] get(double[] densityArray, int x, int z, int xSize, int zSize, double scaleX, double scaleZ) {
        return this.get(densityArray, x, 0.0, z, xSize, 1, zSize, scaleX, 1.0, scaleZ);
    }
}

