/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Random;
import net.minecraft.core.world.noise.BaseImprovedNoise;
import net.minecraft.core.world.noise.LegacyNoiseType;
import org.jetbrains.annotations.NotNull;

public class ImprovedNoise
extends BaseImprovedNoise {
    @NotNull
    private final LegacyNoiseType legacyNoiseType;

    public ImprovedNoise(@NotNull Random random, @NotNull LegacyNoiseType legacyNoiseType) {
        super(random);
        this.legacyNoiseType = legacyNoiseType;
    }

    public ImprovedNoise(@NotNull Random random) {
        this(random, LegacyNoiseType.NONE);
    }

    @Override
    public void add(double @NotNull [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double valueScale) {
        double scale = 1.0 / valueScale;
        if (ySize == 1 && this.legacyNoiseType.handleEdgeCaseY) {
            int i = 0;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)Math.floor(xx) & 0xFF;
                xx -= Math.floor(xx);
                double u = this.fade(xx);
                for (int zi = 0; zi < zSize; ++zi) {
                    double zz = (z + (double)zi) * zScale + this.zo;
                    int Z = (int)Math.floor(zz) & 0xFF;
                    zz -= Math.floor(zz);
                    double w = this.fade(zz);
                    int A = this.p[X];
                    int AA = this.p[A] + Z;
                    int B = this.p[X + 1];
                    int BA = this.p[B] + Z;
                    double value = this.lerp(w, this.lerp(u, this.grad2(this.p[AA], xx, zz), this.grad(this.p[BA], xx - 1.0, 0.0, zz)), this.lerp(u, this.grad(this.p[AA + 1], xx, 0.0, zz - 1.0), this.grad(this.p[BA + 1], xx - 1.0, 0.0, zz - 1.0)));
                    int n = i++;
                    out[n] = out[n] + value * scale;
                }
            }
        } else if (zSize == 1 && this.legacyNoiseType.handleEdgeCaseZ) {
            int i = 0;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)Math.floor(xx) & 0xFF;
                xx -= Math.floor(xx);
                double u = this.fade(xx);
                for (int yi = 0; yi < ySize; ++yi) {
                    double yy = (y + (double)yi) * yScale + this.zo;
                    int Y = (int)Math.floor(yy) & 0xFF;
                    yy -= Math.floor(yy);
                    double v = this.fade(yy);
                    int A = this.p[X];
                    int AA = this.p[A] + Y;
                    int B = this.p[X + 1];
                    int BA = this.p[B] + Y;
                    double value = this.lerp(v, this.lerp(u, this.grad2(this.p[AA], xx, yy), this.grad(this.p[BA], xx - 1.0, 0.0, yy)), this.lerp(u, this.grad(this.p[AA + 1], xx, 0.0, yy - 1.0), this.grad(this.p[BA + 1], xx - 1.0, 0.0, yy - 1.0)));
                    int n = i++;
                    out[n] = out[n] + value * scale;
                }
            }
        } else {
            double lerpedX = 0.0;
            double lerpedXNegY = 0.0;
            double lerpedXNegZ = 0.0;
            double lerpedXNegYNegZ = 0.0;
            int i = 0;
            int lastY = -1;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)Math.floor(xx) & 0xFF;
                xx -= Math.floor(xx);
                double u = this.fade(xx);
                for (int zi = 0; zi < zSize; ++zi) {
                    double zz = (z + (double)zi) * zScale + this.zo;
                    int Z = (int)Math.floor(zz) & 0xFF;
                    zz -= Math.floor(zz);
                    double w = this.fade(zz);
                    for (int yi = 0; yi < ySize; ++yi) {
                        double yy = (y + (double)yi) * yScale + this.yo;
                        int Y = (int)Math.floor(yy) & 0xFF;
                        yy -= Math.floor(yy);
                        double v = this.fade(yy);
                        if (yi == 0 || Y != lastY) {
                            lastY = Y;
                            int A = this.p[X] + Y;
                            int AA = this.p[A] + Z;
                            int AB = this.p[A + 1] + Z;
                            int B = this.p[X + 1] + Y;
                            int BA = this.p[B] + Z;
                            int BB = this.p[B + 1] + Z;
                            lerpedX = this.lerp(u, this.grad(this.p[AA], xx, yy, zz), this.grad(this.p[BA], xx - 1.0, yy, zz));
                            lerpedXNegY = this.lerp(u, this.grad(this.p[AB], xx, yy - 1.0, zz), this.grad(this.p[BB], xx - 1.0, yy - 1.0, zz));
                            lerpedXNegZ = this.lerp(u, this.grad(this.p[AA + 1], xx, yy, zz - 1.0), this.grad(this.p[BA + 1], xx - 1.0, yy, zz - 1.0));
                            lerpedXNegYNegZ = this.lerp(u, this.grad(this.p[AB + 1], xx, yy - 1.0, zz - 1.0), this.grad(this.p[BB + 1], xx - 1.0, yy - 1.0, zz - 1.0));
                        }
                        double lerpedXY = this.lerp(v, lerpedX, lerpedXNegY);
                        double lerpedXYNegZ = this.lerp(v, lerpedXNegZ, lerpedXNegYNegZ);
                        double lerpedXYZ = this.lerp(w, lerpedXY, lerpedXYNegZ);
                        int n = i++;
                        out[n] = out[n] + lerpedXYZ * scale;
                    }
                }
            }
        }
    }
}

