/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.SliderElement;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.shader.PhotoModeRenderer;
import net.minecraft.client.util.helper.FileOpener;
import net.minecraft.client.util.helper.ScreenShot;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL41;

public class ScreenPhotoMode
extends Screen {
    private ButtonElement buttonRotateLeft;
    private ButtonElement buttonRotateRight;
    private ButtonElement buttonCenterScreen;
    private SliderElement sliderTimeOfDay;
    private ButtonElement buttonSeason;
    private ButtonElement buttonTakeScreenshot;
    private ListenerButtonElement buttonOpenScreenshotFolder;
    private ButtonElement buttonExit;
    private SliderElement sliderFog;
    private SliderElement sliderTilt;
    private ButtonElement buttonShaders;
    private SliderElement sliderIntensity;
    private ButtonElement buttonShowPlayer;
    private final long originalTOD;
    private long desiredTOD = -1L;
    private long desiredDay = -1L;
    private int desiredSeason = -1;
    public boolean showPlayer = true;
    protected float iRotation = 0.0f;
    protected float lastIRotation = 0.0f;
    protected float iRotationGoal = 0.0f;
    protected float iZoom = 1.0f;
    protected float lastIZoom = 1.0f;
    protected float iZoomGoal = 1.0f;
    protected float iTilt = 30.0f;
    protected float lastITilt = 30.0f;
    protected float iTiltGoal = 30.0f;
    private float iFog = 1.0f;
    private float lastIFog = 1.0f;
    private float iFogGoal = 1.0f;
    protected float iPanX = 0.0f;
    protected float lastIPanX = 0.0f;
    protected float iPanXGoal = 0.0f;
    protected float iPanY = 0.0f;
    protected float lastIPanY = 0.0f;
    protected float iPanYGoal = 0.0f;
    private boolean isMouseDown = false;
    private int mouseButton;
    private int mouseDownX;
    private int mouseDownY;
    private float lastEndPanX;
    private float lastEndPanY;
    private float lastEndRotation;
    public float intensityValue = 1.0f;
    protected boolean shouldScreenshot = false;
    protected PhotoModeRenderer photoModeRenderer;
    public Renderer previousRenderer;
    protected boolean showHelpText = true;
    protected long lastUpdateTime = 0L;

    public ScreenPhotoMode() {
        Minecraft mc = Minecraft.getMinecraft();
        this.photoModeRenderer = new PhotoModeRenderer(mc, this);
        this.previousRenderer = mc.renderer;
        mc.currentWorld.updateSeasonAndLight();
        this.originalTOD = mc.currentWorld.getWorldTime();
    }

    public float getRotation(float partialTick) {
        return this.lastIRotation + (this.iRotation - this.lastIRotation) * partialTick;
    }

    public float getZoom(float partialTick) {
        return this.lastIZoom + (this.iZoom - this.lastIZoom) * partialTick;
    }

    public float getTilt(float partialTick) {
        return this.lastITilt + (this.iTilt - this.lastITilt) * partialTick;
    }

    public float getFog(float partialTick) {
        return this.lastIFog + (this.iFog - this.lastIFog) * partialTick;
    }

    public float getPanX(float partialTick) {
        return this.lastIPanX + (this.iPanX - this.lastIPanX) * partialTick;
    }

    public float getPanY(float partialTick) {
        return this.lastIPanY + (this.iPanY - this.lastIPanY) * partialTick;
    }

    @Override
    public void init() {
        super.init();
        I18n i18n = I18n.getInstance();
        this.buttonExit = new ButtonElement(5, 0, 0, 20, 20, "X");
        this.buttonRotateLeft = new ButtonElement(0, this.width / 2 - 59 - 2 - 20, this.height - 20, 20, 20, "<");
        this.buttonRotateRight = new ButtonElement(1, this.width / 2 + 59 + 2 + 1, this.height - 20, 20, 20, ">");
        this.buttonTakeScreenshot = new ButtonElement(4, this.width / 2 - 59, this.height - 20, 98, 20, i18n.translateKey("gui.photo_mode.button.take_screenshot"));
        this.buttonOpenScreenshotFolder = (ListenerButtonElement)new ListenerButtonElement(30, this.buttonTakeScreenshot.getWidth() + this.buttonTakeScreenshot.getX() + 1, this.buttonTakeScreenshot.getY(), 20, 20, "").setTextures("minecraft:gui/misc/button_folder", "minecraft:gui/misc/button_folder_highlighted", "minecraft:gui/misc/button_folder");
        this.buttonOpenScreenshotFolder.setActionListener(() -> {
            File f = new File(this.mc.getMinecraftDir(), "screenshots");
            f.mkdirs();
            FileOpener.open(f);
        });
        this.buttonCenterScreen = new ButtonElement(10, this.width - 120, 0, 120, 20, i18n.translateKey("gui.photo_mode.button.center_camera"));
        this.buttonShowPlayer = new ButtonElement(11, this.width - 120, 0, 120, 20, "");
        this.sliderTimeOfDay = new SliderElement(2, this.width - 120, 0, 120, 20, "", 0.0f);
        this.buttonSeason = new ButtonElement(3, this.width - 120, 0, 120, 20, "");
        this.sliderFog = new SliderElement(6, this.width - 120, 0, 120, 20, "", 0.5f);
        this.sliderTilt = new SliderElement(7, this.width - 120, 0, 120, 20, "", 0.33333334f);
        this.buttonShaders = new ButtonElement(8, this.width - 120, 0, 120, 20, "");
        this.sliderIntensity = new SliderElement(9, this.width - 120, 0, 120, 20, "", this.intensityValue);
        if (this.photoModeRenderer.getActiveShader() == null) {
            this.sliderIntensity.enabled = false;
        }
        this.buttons.add(this.buttonCenterScreen);
        this.buttons.add(this.buttonShowPlayer);
        this.buttons.add(this.sliderTilt);
        this.mc.setRenderer(this.photoModeRenderer);
        if (!this.mc.currentWorld.isClientSide) {
            this.buttons.add(this.sliderTimeOfDay);
            this.buttons.add(this.sliderFog);
            this.buttons.add(this.buttonSeason);
        }
        this.buttons.add(this.buttonShaders);
        this.buttons.add(this.sliderIntensity);
        int i = 0;
        for (ButtonElement button : this.buttons) {
            button.yPosition = i++ * 21;
        }
        this.buttons.add(this.buttonRotateLeft);
        this.buttons.add(this.buttonRotateRight);
        this.buttons.add(this.buttonTakeScreenshot);
        this.buttons.add(this.buttonOpenScreenshotFolder);
        this.buttons.add(this.buttonExit);
        if (this.desiredTOD == -1L) {
            this.desiredTOD = this.originalTOD % 24000L;
        } else {
            this.sliderTimeOfDay.sliderValue = (float)this.desiredTOD / 24000.0f;
        }
        if (this.desiredDay == -1L) {
            this.desiredDay = this.originalTOD / 24000L;
        }
        this.updateButtonsText();
    }

    @Override
    public void removed() {
        this.mc.currentWorld.setWorldTimeUpdateTicks(this.originalTOD);
        this.mc.setRenderer(this.previousRenderer);
        this.mc.currentWorld.updateSeasonAndLight();
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (button == this.buttonRotateLeft) {
            this.iRotationGoal += 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        } else if (button == this.buttonRotateRight) {
            this.iRotationGoal -= 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        } else if (button == this.buttonSeason) {
            ++this.desiredSeason;
            if (this.desiredSeason > 3) {
                this.desiredSeason = -1;
            }
            this.desiredDay = this.desiredSeason == -1 ? this.originalTOD / 24000L : 168000L * (long)this.desiredSeason + 72000L;
            this.mc.currentWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.currentWorld.updateSeasonAndLight();
        } else if (button == this.buttonTakeScreenshot) {
            this.shouldScreenshot = true;
        } else if (button == this.buttonExit) {
            this.mc.displayScreen(null);
        } else if (button == this.buttonShaders) {
            boolean ctrl;
            boolean bl = ctrl = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
            if (ctrl) {
                this.photoModeRenderer.first();
            } else {
                this.photoModeRenderer.next();
            }
            this.sliderIntensity.enabled = this.photoModeRenderer.getActiveShader() != null;
        } else if (button == this.buttonCenterScreen) {
            this.iPanXGoal = 0.0f;
            this.iPanYGoal = 0.0f;
        } else if (button == this.buttonShowPlayer) {
            this.showPlayer = !this.showPlayer;
        }
        this.updateButtonsText();
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (!this.isMouseDown && this.clickedButton == null) {
            this.showHelpText = false;
            this.isMouseDown = true;
            this.mouseDownX = mx;
            this.mouseDownY = my;
            this.lastEndPanX = this.iPanX;
            this.lastEndPanY = this.iPanY;
            this.lastEndRotation = this.iRotation;
            this.mouseButton = buttonNum;
        }
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        if (this.isMouseDown && buttonNum != -1) {
            this.isMouseDown = false;
        } else if (this.isMouseDown) {
            if (this.mouseButton == 0) {
                float div = (float)Math.pow(2.0, this.iZoom) / 3.0f;
                this.iPanXGoal = this.lastEndPanX + (float)(mx - this.mouseDownX) / div;
                this.iPanYGoal = this.lastEndPanY + (float)(my - this.mouseDownY) / div;
            } else {
                this.iRotationGoal = this.lastEndRotation + (float)(mx - this.mouseDownX) / 128.0f;
            }
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        long currentTime;
        GL41.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        GLRenderer.projectionM4f().identity().ortho(0.0f, (float)this.mc.resolution.getExactScaledWidthScreenCoords(), (float)this.mc.resolution.getExactScaledHeightScreenCoords(), 0.0f, 1000.0f, 3000.0f);
        GLRenderer.viewM4f().identity();
        GLRenderer.modelM4f().identity();
        GL41.glClear(256);
        GLRenderer.modelM4f().translate(0.0f, 0.0f, -2000.0f);
        if (this.mc.controllerInput != null) {
            if (this.mc.controllerInput.buttonLeftShoulder.isPressed()) {
                float div = (float)Math.pow(2.0, this.iZoom) / 3.0f;
                this.iPanXGoal -= this.mc.controllerInput.joyRight.getX() / div;
                this.iPanYGoal -= this.mc.controllerInput.joyRight.getY() / div;
            } else if (this.mc.controllerInput.buttonLeftTrigger.isPressed()) {
                this.iTiltGoal -= this.mc.controllerInput.joyRight.getY() / 2.0f;
                this.iTiltGoal = MathHelper.clamp(this.iTiltGoal, 0.0f, 90.0f);
                this.updateButtonsText();
            } else {
                this.iRotationGoal -= this.mc.controllerInput.joyRight.getX() / 64.0f;
                this.iZoomGoal -= this.mc.controllerInput.joyRight.getY() / 128.0f;
            }
        }
        if ((currentTime = System.currentTimeMillis()) > this.lastUpdateTime + 5L) {
            this.lastIZoom = this.iZoom;
            if (this.iZoom != this.iZoomGoal) {
                this.iZoom += (this.iZoomGoal - this.iZoom) * 0.08f;
                if (Math.abs(this.iZoom - this.iZoomGoal) < 5.0E-4f) {
                    this.iZoom = this.iZoomGoal;
                }
            }
            this.lastIRotation = this.iRotation;
            if (this.iRotation != this.iRotationGoal) {
                this.iRotation += (this.iRotationGoal - this.iRotation) * 0.08f;
                if (Math.abs(this.iRotation - this.iRotationGoal) < 5.0E-4f) {
                    this.iRotation = this.iRotationGoal;
                }
            }
            this.lastITilt = this.iTilt;
            if (this.iTilt != this.iTiltGoal) {
                this.iTilt += (this.iTiltGoal - this.iTilt) * 0.08f;
                if (Math.abs(this.iTilt - this.iTiltGoal) < 0.01f) {
                    this.iTilt = this.iTiltGoal;
                }
            }
            this.lastIFog = this.iFog;
            if (this.iFog != this.iFogGoal) {
                this.iFog += (this.iFogGoal - this.iFog) * 0.08f;
                if (Math.abs(this.iFog - this.iFogGoal) < 5.0E-5f) {
                    this.iFog = this.iFogGoal;
                }
            }
            this.lastIPanX = this.iPanX;
            if (this.iPanX != this.iPanXGoal) {
                this.iPanX += (this.iPanXGoal - this.iPanX) * 0.4f;
                if (Math.abs(this.iPanX - this.iPanXGoal) < 0.01f) {
                    this.iPanX = this.iPanXGoal;
                }
            }
            this.lastIPanY = this.iPanY;
            if (this.iPanY != this.iPanYGoal) {
                this.iPanY += (this.iPanYGoal - this.iPanY) * 0.4f;
                if (Math.abs(this.iPanY - this.iPanYGoal) < 0.01f) {
                    this.iPanY = this.iPanYGoal;
                }
            }
            this.lastUpdateTime = currentTime;
        }
        boolean bl = this.buttonCenterScreen.enabled = !(this.iPanX == 0.0f && this.iPanY == 0.0f || this.iPanXGoal == 0.0f && this.iPanYGoal == 0.0f);
        if (!this.shouldScreenshot) {
            super.render(mx, my, partialTick);
        } else {
            ScreenShot.saveScreenshot(Global.accessor.getMinecraftDir(), this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
            this.shouldScreenshot = false;
        }
        this.scroll(Mouse.getDWheel());
        if (this.sliderTimeOfDay.dragging) {
            long sliderTOD = (long)(this.sliderTimeOfDay.sliderValue * 24000.0);
            this.desiredTOD = this.sliderTimeOfDay.sliderValue == 0.0 ? this.originalTOD % 24000L : sliderTOD;
            this.mc.currentWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.currentWorld.updateSeasonAndLight();
            this.updateButtonsText();
        }
        if (this.sliderTilt.dragging) {
            this.iTiltGoal = (int)(this.sliderTilt.sliderValue * 90.0);
            this.updateButtonsText();
        }
        if (this.sliderFog.dragging) {
            this.iFogGoal = (float)Math.pow(2.0, 8.0 * this.sliderFog.sliderValue * 2.0 - 8.0);
            this.updateButtonsText();
        }
        if (this.sliderIntensity.dragging) {
            this.intensityValue = (float)this.sliderIntensity.sliderValue;
            this.updateButtonsText();
        }
        if (this.showHelpText) {
            this.drawStringCenteredShadow(this.fontRenderer, I18n.getInstance().translateKey("gui.photo_mode.label.mouse_hint"), this.width / 2, this.height - 36, 0xFFFFFF);
        }
    }

    private void updateButtonsText() {
        I18n i18n = I18n.getInstance();
        if (this.buttonSeason != null) {
            Season[] seasons = new Season[]{Seasons.OVERWORLD_SPRING, Seasons.OVERWORLD_SUMMER, Seasons.OVERWORLD_FALL, Seasons.OVERWORLD_WINTER};
            String seasonName = i18n.translateKey("gui.photo_mode.button.season.default");
            if (this.desiredSeason >= 0) {
                seasonName = seasons[this.desiredSeason].getTranslatedName().toUpperCase(Locale.ROOT);
            }
            this.buttonSeason.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.season", seasonName);
        }
        String timeOfDay = i18n.translateKey("gui.photo_mode.button.time_of_day.default");
        if (this.sliderTimeOfDay.sliderValue != 0.0) {
            timeOfDay = String.valueOf((long)(this.sliderTimeOfDay.sliderValue * 24000.0));
        }
        this.sliderTimeOfDay.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.time_of_day", timeOfDay);
        this.sliderFog.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.fog", (int)(this.sliderFog.sliderValue * 200.0) + "%");
        Object tilt = i18n.translateKey("gui.photo_mode.button.tilt.default");
        if ((int)(this.sliderTilt.sliderValue * 90.0) != 30) {
            tilt = (int)(this.sliderTilt.sliderValue * 90.0) + " degrees";
        }
        this.sliderTilt.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.tilt", tilt);
        String activeShader = this.photoModeRenderer.getActiveShader();
        if (activeShader == null) {
            activeShader = i18n.translateKey("gui.photo_mode.button.shader.none");
        }
        activeShader = activeShader.toUpperCase(Locale.ROOT);
        this.buttonShaders.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.shader", activeShader);
        this.sliderIntensity.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.intensity", (int)(this.sliderIntensity.sliderValue * 100.0) + "%");
        this.buttonShowPlayer.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.show_player", this.showPlayer ? i18n.translateKey("gui.photo_mode.button.show_player.on") : i18n.translateKey("gui.photo_mode.button.show_player.off"));
    }

    public void scroll(int i) {
        if (i < 0) {
            this.iZoomGoal -= 0.25f;
        } else if (i > 0) {
            this.iZoomGoal += 0.25f;
        }
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        super.guiSpecificControllerInput(controller);
    }
}

