/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.chat;

import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.chat.GuiElementChatEmotePicker;
import net.minecraft.client.gui.chat.ScreenChat;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.net.packet.PacketUpdatePlayerState;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public class ScreenSleepMP
extends ScreenChat {
    @Override
    public void init() {
        Keyboard.enableRepeatEvents(true);
        I18n i18n = I18n.getInstance();
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height - 40, i18n.translateKey("gui.sleeping.multiplayer.leave_bed")));
        int emotePickerYCells = (int)MathHelper.clamp(Math.ceil((double)ChatEmotes.getEmotes().size() / 5.0), 0.0, 4.0);
        this.emotePicker = new GuiElementChatEmotePicker(this.mc, this, 5, emotePickerYCells);
        this.showEmotePicker = false;
        super.init();
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        super.keyPressed(eventCharacter, eventKey, mx, my);
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.leaveBed();
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        super.render(mx, my, partialTick);
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (button.id == 1) {
            this.leaveBed();
        } else {
            super.buttonClicked(button);
        }
    }

    private void leaveBed() {
        if (this.mc.thePlayer instanceof PlayerLocalMultiplayer) {
            PacketHandlerClient sendQueue = ((PlayerLocalMultiplayer)this.mc.thePlayer).sendQueue;
            sendQueue.addToSendQueue(new PacketUpdatePlayerState(3));
        }
    }
}

